/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.api.dto;

import cn.com.duiba.order.center.api.dto.AppDto;
import cn.com.duiba.order.center.api.dto.AppItemDto;
import cn.com.duiba.order.center.api.dto.ItemDto;
import java.io.Serializable;

public class ItemKeyDto
implements Serializable {
    private static final long serialVersionUID = 1234212321L;
    private final ItemDto item;
    private final AppItemDto appItem;
    private final AppDto app;

    public static ItemKeyDto generate(ItemDto item, AppItemDto appItem, AppDto app) {
        return new ItemKeyDto(item, appItem, app);
    }

    protected ItemKeyDto(ItemDto item, AppItemDto appItem, AppDto app) {
        this.item = item;
        this.appItem = appItem;
        this.app = app;
    }

    private ItemKeyDto() {
        this.item = null;
        this.appItem = null;
        this.app = null;
    }

    public String getItemType() {
        if (this.getItem() != null) {
            return this.getItem().getType();
        }
        if (this.getAppItem() != null) {
            return this.getAppItem().getType();
        }
        return null;
    }

    public ItemDto getItem() {
        return this.item;
    }

    public AppItemDto getAppItem() {
        return this.appItem;
    }

    public boolean isValid() {
        return this.getItem() != null || this.getAppItem() != null;
    }

    public boolean isItemMode() {
        return this.item != null && this.appItem == null;
    }

    public boolean isSelfAppItemMode() {
        return this.item == null && this.appItem != null;
    }

    public boolean isDuibaAppItemMode() {
        return this.item != null && this.appItem != null;
    }

    public AppDto getApp() {
        return this.app;
    }

    public Boolean isAmbItemKey() {
        if (this.isDuibaAppItemMode()) {
            return false;
        }
        if (this.isSelfAppItemMode()) {
            return this.appItem.isOpTypeAppItem(11);
        }
        return this.item.isOpTypeItem(11);
    }
}

