package cn.com.duiba.order.center.api.dto;

import cn.com.duiba.service.domain.dataobject.ConsumerExtraDO;
import cn.com.duiba.service.item.domain.vo.ItemKeyVO;

/**
 * 跑马灯对象
 */
public class ChomeMarqueeDto {

	private String url;

	private String smallImage;

	private String credits;

	private String nickname;

	public ChomeMarqueeDto(ItemKeyVO keyVO, ConsumerExtraDO ce) {
		if (keyVO.getItemId() != null) {
			this.url = "/mobile/detail?itemId=" + keyVO.getItemId() + "&dbnewopen";
		} else {
			this.url = "/mobile/appItemDetail?appItemId=" + keyVO.getAppItemId() + "&dbnewopen";
		}
		this.smallImage = keyVO.getSmallImage();
		//this.credits = keyVO.getCredits() + "";TODO
		this.nickname = ce == null?"":ce.getNickname();
	}

	public ChomeMarqueeDto() {
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getSmallImage() {
		return smallImage;
	}

	public void setSmallImage(String smallImage) {
		this.smallImage = smallImage;
	}

	public String getCredits() {
		return credits;
	}

	public void setCredits(String credits) {
		this.credits = credits;
	}

	public String getNickname() {
		return nickname;
	}

	public void setNickname(String nickname) {
		this.nickname = nickname;
	}

}
