package cn.com.duiba.order.center.api.dto;

import cn.com.duiba.service.tools.DuibaEvent;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by yansen on 16/8/15.
 */
public class OrderCreateContext implements Serializable{

    private static final long serialVersionUID = 2957757651367585222L;
    private DuibaEvent.RequestParams params;
    private Integer actualPrice;
    private Long itemId;
    private Long appItemId;
    private Long appId;
    private Long consumerId;
    private Long orderId;
    private String chargeMode;
    private Map<String,Object> paramsMap;
    private Long supplierProductId;

    public OrderCreateContext() {
    }

    public OrderCreateContext(DuibaEvent.RequestParams params, Integer actualPrice, Long itemId, Long appItemId, Long appId, Long consumerId, Long orderId, String chargeMode, Long supplierProductId) {
        this.params = params;
        this.actualPrice = actualPrice;
        this.itemId = itemId;
        this.appItemId = appItemId;
        this.appId = appId;
        this.consumerId = consumerId;
        this.orderId = orderId;
        this.chargeMode = chargeMode;
        this.supplierProductId = supplierProductId;
    }


    public DuibaEvent.RequestParams getParams() {
        return params;
    }

    public void setParams(DuibaEvent.RequestParams params) {
        this.params = params;
    }

    public Integer getActualPrice() {
        return actualPrice;
    }

    public void setActualPrice(Integer actualPrice) {
        this.actualPrice = actualPrice;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public String getChargeMode() {
        return chargeMode;
    }

    public void setChargeMode(String chargeMode) {
        this.chargeMode = chargeMode;
    }

    public Map<String, Object> getParamsMap() {
        return paramsMap;
    }

    public void setParamsMap(Map<String, Object> paramsMap) {
        this.paramsMap = paramsMap;
    }

    public void addParam(String key,Object value){
        if(paramsMap==null||paramsMap.isEmpty()){
            paramsMap=new HashMap<>();
        }
        paramsMap.put(key,value);
    }

    public Long getSupplierProductId() {
        return supplierProductId;
    }

    public void setSupplierProductId(Long supplierProductId) {
        this.supplierProductId = supplierProductId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }
}
