package cn.com.duiba.order.center.api.dto.order_process;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by yansen on 16/7/14.
 */
public class OrdersProcessDto implements Serializable{

    private static final long serialVersionUID = 2668178876319446881L;

    public static final int StatusSuccess = 1;// 处理成功
    public static final int StatusFail = 0;// 处理失败

    private Long id;
    private Long orderId; // 订单
    private String orderNum; // 订单号 同Orders.orderNum
    private Long operatorId; // 处理人
    private Integer statusInt; // 处理状态 Orders.statuInt
    private Integer typeInt; // 订单类型 Orders.typeInt
    private String memo; // 备注
    private String type;
    private Date gmtCreate;
    private Date gmtModified;

    public OrdersProcessDto() {
    }

    public OrdersProcessDto(Long id) {
        this.id = id;
        this.gmtModified = new Date();
    }

    public OrdersProcessDto(boolean init4insert) {
        if (init4insert) {
            gmtCreate = new Date();
            gmtModified = gmtCreate;
        }
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public Integer getStatusInt() {
        return statusInt;
    }

    public void setStatusInt(Integer statusInt) {
        this.statusInt = statusInt;
    }

    public Integer getTypeInt() {
        return typeInt;
    }

    public void setTypeInt(Integer typeInt) {
        this.typeInt = typeInt;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
}
