package cn.com.duiba.order.center.api.remoteservice.amb;

import cn.com.duiba.order.center.api.dto.AmbDeveloperWithdrawCashAuditViewDto;

import java.util.List;

public interface RemoteAmbDeveloperWithdrawCashAuditService {

	/**
     * 新增审核信息
     * @param ambDeveloperWithdrawCashAuditDO
     */
    public cn.com.duiba.order.center.api.dto.amb.AmbDeveloperWithdrawCashAuditDto insert(cn.com.duiba.order.center.api.dto.amb.AmbDeveloperWithdrawCashAuditDto ambDeveloperWithdrawCashAuditDO);

    /**
     * 根据ID查询
     * @param id
     * @return
     */
    public cn.com.duiba.order.center.api.dto.amb.AmbDeveloperWithdrawCashAuditDto findById(Long id);

    /**
     * 获取有效的审核通过的审核信息
     * @param developerId
     * @param cashType 提现类型
     * @return
     */
    public cn.com.duiba.order.center.api.dto.amb.AmbDeveloperWithdrawCashAuditDto findValidPassAudit(Long developerId, String cashType);

    /**
     * 获取正在审核的信息
     * @param developerId
     * @return
     */
    public cn.com.duiba.order.center.api.dto.amb.AmbDeveloperWithdrawCashAuditDto findAuditing(Long developerId, String cashType);

    /**
     * 禁用所有效的审核
     * @param developerId
     * @param cashType
     */
    public void disableValidPassAudit(Long developerId,String cashType);

    /**
     * 将审核材料的状态由创建更新为待审核
     * @param auditId
     * @return
     */
    public int updateStatusCreateToWait(Long auditId);

    /**
     * @param auditIds
     */
    public List<cn.com.duiba.order.center.api.dto.amb.AmbDeveloperWithdrawCashAuditDto> findByIds(List<Long> auditIds);

    public List<AmbDeveloperWithdrawCashAuditViewDto> findPageList(String email, String status, Integer offset, Integer max);

    public Long findPageCount(String email, String status);

    public int updateConfirmAudit(Long id);

    public int updateRejectAudit(Long id, String description);
}
