package cn.com.duiba.order.center.api.remoteservice.amb;

import cn.com.duiba.order.center.api.dto.AmbPostsaleOrdersViewDto;

import java.util.List;

public interface RemoteAmbPostsaleOrdersService {

	public cn.com.duiba.order.center.api.dto.amb.AmbPostsaleOrdersDto find(Long id);

	public cn.com.duiba.order.center.api.dto.amb.AmbPostsaleOrdersDto findForUpdate(Long id);

	public cn.com.duiba.order.center.api.dto.amb.AmbPostsaleOrdersDto findByOrderId(Long orderId);

	public cn.com.duiba.order.center.api.dto.amb.AmbPostsaleOrdersDto insert(cn.com.duiba.order.center.api.dto.amb.AmbPostsaleOrdersDto ambPostsaleOrders);

	public void update(cn.com.duiba.order.center.api.dto.amb.AmbPostsaleOrdersDto ambPostsaleOrders);

	public List<cn.com.duiba.order.center.api.dto.amb.AmbPostsaleOrdersDto> findAllByIds(List<Long> ids);

	public List<cn.com.duiba.order.center.api.dto.amb.AmbPostsaleOrdersDto> findAllByOrderId(Long orderId);

	public List<AmbPostsaleOrdersViewDto> findPageList(Long orderId, List<Long> appIds, Integer offset, Integer max);

    public Long findPageCount(Long orderId,List<Long> appIds);

    public Long findDealingCount();
	/**
	 * 同意售后
	 */
	public void agree(Long postsaleOrderId, String remark);

	/**
	 * 拒绝售后
	 */
	public void reject(Long postsaleOrderId, String remark);

	/**
	 * 取消售后
	 */
	public void cancel(Long postsaleOrderId);

	/**
	 * 完成售后
	 * @throws Exception
	 */
	public void complete(Long postsaleOrderId, Long consumerId) throws Exception;

	/**
	 * 成功流程
	 */
	public void doSuccess(Long postsaleOrderId);
    
}
