package cn.com.duiba.order.center.api.remoteservice.flowwork;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;

import cn.com.duiba.order.center.api.dto.flowwork.AlipayOrderResponseDetail;
import cn.com.duiba.order.center.api.dto.flowwork.SupplierResponse;

public interface RemoteSupplierExchangeFlowWorkerService {
	
	public void onFinish(final Long orderId, final Long consumerId, final SupplierResponse resp);
	
	public void onException(final Long orderId, final Long consumerId, final Exception ex);
	
	/**
	 * 虚拟商品上游调用
	 * @param orderId
	 * @param request
	 * @return
	 * @throws Exception
	 */
	public boolean callbackFromVirtualSupplier(Long orderId, Long consumerId, HttpServletRequest request) throws Exception;
	
	/**
	 * 支付宝单条调用，目前被Ctrl调用
	 * @param orderId
	 * @param detail
	 * @return
	 * @throws Exception
	 */
	public boolean callbackProcessByDetail(Long orderId, Long consuemrId, AlipayOrderResponseDetail detail) throws Exception;
	
	/**
	 * 话费上游调用
	 * @param orderId
	 * @param request
	 * @return
	 * @throws Exception
	 */
	public boolean callbackFromPhonebillSupplier(Long orderId, Long consumerId, HttpServletRequest request) throws Exception;
	
	/**
	 * 流量上游调用
	 * @param orderId
	 * @param request
	 * @return 流程是否能够继续
	 * @throws Exception
	 */
	public boolean callbackFromPhoneflowSupplier(Long orderId, Long consumerId, HttpServletRequest request) throws Exception;
	
	/**
	 * QB上游调用
	 * @param request
	 * @throws Exception
	 */
	public boolean callbackFromQbSupplier(Long orderId, Long consumerId, HttpServletRequest request) throws Exception;
	
	/**
	 * 实物商品执行发货操作
	 * @param expressName
	 * @param expressId
	 * @throws Exception
	 */
	public void executeSend(Long orderId, Long consumerId, String expressName,String expressId) throws Exception;
	
	/**
	 * 开发者自有实物，执行取消发货动作
	 * @param orderId
	 * @param reason
	 */
	public void executeCancel(Long orderId, Long consumerId, String reason) throws Exception;
	
	/**
	 * 手动开奖的实物，执行发货操作
	 * @param expressName
	 * @param expressId
	 * @throws Exception
	 */
	public void executeManualLotterySend(Long orderId, Long consumerId, String shipInfo) throws Exception;
	
	/**
	 * 支付宝重试入口
	 * @param orderId
	 * @param reInput
	 * @param params
	 * @param listener
	 * @throws Exception
	 */
	public void retryAlipayExchange(final Long orderId, final Long consumerId, final boolean reInput,Map<String, Object> params) throws Exception;
	
	/**
	 * 话费重试入口
	 * @param orderId
	 * @param reInput
	 * @param params
	 * @param listener
	 * @throws Exception
	 */
	public void retryPhonebillExchange(final Long orderId, final Long consumerId, final boolean reInput, Map<String, Object> params) throws Exception;
	
	/**
	 * QB重试入口
	 * @param orderId
	 * @param reInput
	 * @param params
	 * @param listener
	 * @throws Exception
	 */
	public void retryQbExchange(final Long orderId, final Long consumerId, final boolean reInput, Map<String, Object> params) throws Exception;
	
	/**
	 * 实物重填信息重试入口
	 * @param orderId
	 * @param reInput
	 * @param params
	 * @param listener
	 * @throws Exception
	 */
	public void retryObjectExchange(final Long orderId, final Long consumerId, final boolean reInput,  Map<String, Object> params) throws Exception;
	
	public boolean fixStatusBySupplierQuery(Long orderId, Long consumerId) throws Exception;
	
	public void mngForceSupplierFail(Long orderId, Long consumerId) throws Exception;
	
	public void mngForceSupplierSuccess(Long orderId, Long consumerId) throws Exception;
	
	/**
	 * 虚拟商品，上游兑换成功操作
	 * @param orderId
	 * @throws Exception
	 */
	public void virtualMakeComplete(Long orderId, Long consumerId) throws Exception;
	
	/**
	 * 虚拟商品，上游兑换失败操作
	 * @param orderId
	 * @throws Exception
	 */
	public void virtualMakeFail(Long orderId, Long consumerId) throws Exception;
	
	/**
	 * 管理员取消订单
	 * @param orderId
	 * @throws Exception
	 */
	public void adminCancel(Long orderId, Long consumerId) throws Exception;
	
}
