package cn.com.duiba.order.center.api.remoteservice.orders_faster;

import cn.com.duiba.order.center.api.dto.orders.OrdersPageInfoDto;
import cn.com.duiba.order.center.api.dto.orders_faster.OrdersFasterDto;
import cn.com.duiba.order.center.api.dto.queryparam.AabnormalOrderQueryDto;
import cn.com.duiba.order.center.api.dto.DevAbnormalOrderDto;
import cn.com.duiba.order.center.api.vo.OrderFasterDto;
import cn.com.duiba.service.domain.dataobject.OrdersFasterDO;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/7/20.
 */
public interface RemoteOrdersFasterBizReadService {

    public Integer getProcessingOrdersCount(Long appId, Date startDay, Date endDay);

    public Integer getAuditOrdersCount(Long appId);

    public Integer getVirtualAbnormalOrdersCount(Long appId,Date delayTime);

    public Long getWaitOrdersCount(Long appId);

    public Map<String, Long> getTimeOutRowAndMax(Map<String, Object> queryMap);

    public List<Long> findTimeOutExportOrderIds(Map<String,Object> queryMap);

    public List<Long> findWaitExportOrderIds(Map<String, Object> queryMap);

    public Map<String, Long> getWaitRowAndMax(Map<String, Object> queryMap);

    public List<DevAbnormalOrderDto> findVirtualAbnormalOrder(Map<String,Object> queryMap);

    public Long findVirtualAbnormalOrderCount(Map<String,Object> queryMap);

    public List<OrderFasterDto> findDevWaitOrderFast(Map<String,Object> paramMap);

    public Long findDevWaitOrderFastCount(Map<String, Object> paramMap);

    public List<OrdersFasterDto> findSencodeKillOrder(Map<String,Object> queryMap);

    public Long findSencodeKillOrderCount(Map<String,Object> queryMap);

    public List<OrdersFasterDto> findTimeoutOrder(AabnormalOrderQueryDto queryEntity);

    public Long findTimeoutOrderCount(AabnormalOrderQueryDto queryEntity);

    public List<OrdersFasterDto> findLotteryTimeoutOrder(AabnormalOrderQueryDto queryEntity);

    public Long findLotteryTimeoutOrderCount(AabnormalOrderQueryDto queryEntity);

    public List<OrdersFasterDto> findHdToolTimeoutOrder(AabnormalOrderQueryDto queryEntity);

    public Long findHdToolTimeoutOrderCount(AabnormalOrderQueryDto queryEntity);

    public List<OrderFasterDto> findOrderFastShippNew(OrdersPageInfoDto pageInfo);

    public Long findOrderFastShippNewCount(OrdersPageInfoDto pageInfo);

    public List<OrderFasterDto> findAuditOrderFast(Map<String,Object> paramMap);

    public Long findAuditOrderFastCount(Map<String,Object> paramMap);

    public List<Long> findExportShippDuibaOrders(OrdersPageInfoDto pageInfo);

    public Long getShippDuibaMax(OrdersPageInfoDto pageInfo);

    public Long getShippDuibaCount(OrdersPageInfoDto pageInfo);

    List<OrderFasterDto> findDevWaitOrderFastByOrderNum(Map<String, Object> paramMap);

    List<OrdersFasterDto> findSencondKillOrderByOrderNum(List<String> orderNums);

    //

    public Map<String, Long> getTimeOutRowAndMax(Date endTime, String orderNum, String type);

    public List<Long> findTimeOutExportOrderIds(Date endTime, String orderNum, String type, Long maxId, Integer offset, Integer max);

    public List<Long> findWaitExportOrderIds(Long appId, String itemTitle, String receiverTel, Long consumerId, String orderNum, Date startDate, Date endDate, Long maxId,String isDevOrder,String isDuibaOrder, Integer offset, Integer max);

    public Map<String, Long> getWaitRowAndMax(Long appId, String itemTitle, String receiverTel, Long consumerId, String orderNum, Date startDate, Date endDate, Long maxId, String isDevOrder,String isDuibaOrder, Integer offset, Integer max);

    public List<cn.com.duiba.service.domain.vo.DevAbnormalOrderVO> findVirtualAbnormalOrder(Long appId, String orderNum, String supplierBizId, Long consumerId, Date timeout, Integer offset, Integer max);

    public Long findVirtualAbnormalOrderCount(Long appId, String orderNum, String supplierBizId, Long consumerId, Date timeout);

    public List<cn.com.duiba.service.domain.vo.OrderFasterVO> findDevWaitOrderFast(Long appId, String itemTitle, String receiverTel, Long consumerId, String orderNum, Date startDate, Date endDate, String isDevOrder, String isDuibaOrder, Integer start, Integer pageSize);

    public Long findDevWaitOrderFastCount(Long appId, String itemTitle, String receiverTel, Long consumerId, String orderNum, Date startDate, Date endDate, String isDevOrder,String isDuibaOrder) ;

    public List<cn.com.duiba.service.domain.vo.OrderFasterVO> findDevWaitOrderFastByOrderNum(Long appId, String orderNum);

    public List<OrdersFasterDO> findSencodeKillOrder(String orderNum, String type, Integer start, Integer pageSize);

    public Long findSencodeKillOrderCount(String orderNum, String type);

    public List<OrdersFasterDO> findTimeoutOrder(Date endTime, String orderNum, String type, Long maxId, Integer offset, Integer max);

    public Long findTimeoutOrderCount(Date endTime, String orderNum, String type);

    public List<OrdersFasterDO> findLotteryTimeoutOrder(Date timeoutTime, String orderNum, String type, Long maxId, Date startTime, Date endTime, Integer offset, Integer max);

    public Long findLotteryTimeoutOrderCount(Date timeoutTime, String orderNum, String type, Long maxId, Date startTime, Date endTime);

    public List<OrdersFasterDO> findHdToolTimeoutOrder(Date timeoutTime, String orderNum, String type, Long maxId, Date startTime, Date endTime, Integer offset, Integer max);

    public Long findHdToolTimeoutOrderCount(Date timeoutTime, String orderNum, String type, Long maxId, Date startTime, Date endTime);

    public List<cn.com.duiba.service.domain.vo.OrderFasterVO> findOrderFastShippNew(String exchangeStatus, String orderId, String objectName, String remarks, String haveRemarks, String orderSource, Integer offset, Integer max);

    public Long findOrderFastShippNewCount(String exchangeStatus, String orderId, String objectName, String remarks, String haveRemarks, String orderSource);


    public List<Long> findExportShippDuibaOrders(String exchangeStatus, String orderId, String objectName, String remarks, String haveRemarks, String orderSource,Long maxId, Integer offset, Integer max);

    public Long getShippDuibaMax(String exchangeStatus, String orderId, String objectName, String remarks, String haveRemarks, String orderSource) ;

    public Long getShippDuibaCount(String exchangeStatus, String orderId, String objectName, String remarks, String haveRemarks, String orderSource,Long maxId);

}
