package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by yansen on 16/9/22.
 */
public interface RemoteOrdersStatusChangeService {
    /**
     * 更新支付状态
     * @param orderId
     * @param consumerId
     * @param payStatus
     * @return
     */
    public DubboResult<Integer> updatePayOrderStatus(Long orderId, Long consumerId, String payStatus);

    /**
     * 扣积分成功，订单状态变更
     * @param orderId
     * @param consumerId
     * @return
     */
    public DubboResult<Integer> doMakeConsumeSuccess(Long orderId, Long consumerId);

    /**
     * 扣积分失败，订单状态变更
     * @param orderId
     * @param consumerId
     * @return
     */
    public DubboResult<Integer> doMakeConsumeFail( Long orderId, Long consumerId, Integer failType,String error4consumer,String error4developer, String error4admin);

    /**加钱购支付成功 后 更新加钱购支付状态  为  pay_success**/
    public DubboResult<Integer> doAmbConsumerPayStatusPaySuccess(Long orderId, Long consumerId);

    public DubboResult<Integer> doAuditPass(Long orderId, Long consumerId);

    public DubboResult<Integer> doAuditReject(Long orderId, Long consumerId, String error4consumer, String error4developer, String error4admin, Integer failType);

    public DubboResult<Integer> doMakeSuccess(Long orderId, Long consumerId, String payStatus, String duibaPayStatus, String consumerPayStatus);

    DubboResult<Integer> doMakeFail(Long orderId, Long consumerId, String payStatus, String duibaPayStatus, String consumerPayStatus, Long consumerPaybackPrice);

    public DubboResult<Integer> updateDuibaPayOrderStatus(Long orderId, Long consumerId, String duibaPayStatus);

    public DubboResult<Integer> doUpdateAllowInputUsed(Long orderId, Long consumerId, Long supplierOrderId, String bizParams, String brief);
}
