package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;

/**
 * Created by yansen on 16/9/27.
 */
public interface RemoteOrdersTextChangeService {
    /**
     * 更新订单错误信息，状态，错误类型
     *
     * @param orderId
     * @param failType
     * @param status
     * @param errorMessage
     * @param error4Consumer
     * @param error4Develper
     * @param error4Admin
     * @return
     */
    public DubboResult<Integer> updateErrorMessageAndFailType(Long orderId, Long consumerId, Integer failType, String errorMessage,
                                                             String error4Consumer, String error4Develper, String error4Admin);

    /**
     * 更新最后发送时间
     *
     * @param orderId
     * @param lastSendTime
     * @return
     */
    public DubboResult<Integer> updateLastSendTime(Long orderId, Long consumerId, Date lastSendTime);

    /**
     * 更新开发者订单号
     * @param orderId
     * @param developBizId
     * @return
     */
    public DubboResult<Integer> updateDevelopBizId(Long orderId,Long consumerId, String developBizId);
}
