/**
 * Project Name:trade-center-api
 * File Name:RemoteAmbPostsaleService.java
 * Package Name:cn.com.duiba.order.center.api.remoteservice.amb
 * Date:2017年2月7日下午2:42:04
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.order.center.api.dto.AmbPostsaleOrdersDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteAmbPostsaleService <br/>
 * Date:     2017年2月7日 下午2:42:04 <br/>
 * @author   admin
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteAmbPostsaleService {

    /**
     * 校验是否能发起售后
     *
     * @param orderId       兑吧订单号
     * @param consumerId    兑吧用户ID
     * @param postsaleMoney 退款金额
     * @return DubboResult
     */
    DubboResult<Void> checkSubmitPostsale(Long orderId, Long consumerId, Long postsaleMoney);
    
    /**
     * 提交售后
     * @param postsaleOrder
     * @param consumerId
     * @return DubboResult
     */
    DubboResult<Void> submit(AmbPostsaleOrdersDto postsaleOrder, Long consumerId);
    
    /**
     * 取消售后
     * @param postsaleOrder
     * @param consumerId
     * @return DubboResult
     */
    DubboResult<Void> cancel(Long subOrderId,Long consumerId);
}

