/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.api.dto;

import cn.com.duiba.service.tools.SecureTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class RequestParams
implements Serializable {
    private static final long serialVersionUID = 5758075167406488621L;
    public static final String LOCALHOST_IP = "127.0.0.1";
    private String userAgent = "";
    private Long consumerId;
    private String ip;
    private Map<String, String> cookies = Collections.emptyMap();

    public String getUserAgent() {
        return this.userAgent;
    }

    public Long getConsumerId() {
        return this.consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getCookie(String name) {
        return this.cookies.get(name);
    }

    public void setCookies(Map<String, String> cookies) {
        this.cookies = cookies;
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public static RequestParams parse(HttpServletRequest request) {
        RequestParams rp = new RequestParams();
        String ua = request.getHeader("User-Agent");
        if (StringUtils.isNotBlank((String)ua)) {
            rp.userAgent = ua.toLowerCase();
        }
        rp.ip = RequestParams.parseIp(request);
        Map<String, String> cookieMap = RequestParams.parseCookies(request);
        rp.consumerId = RequestParams.parseCid(cookieMap);
        rp.cookies = cookieMap;
        return rp;
    }

    public static Long parseCid(Map<String, String> cookieMap) {
        String wdata3 = cookieMap.get("wdata3");
        if (wdata3 != null) {
            String content = SecureTool.decryptConsumerCookie((String)wdata3);
            JSONObject json = JSON.parseObject((String)content);
            if (new Date().getTime() - json.getLong("time") < 86400000L) {
                return json.getLong("cid");
            }
        } else {
            String jsdata3 = cookieMap.get("jsdata3");
            if (jsdata3 != null) {
                String content = SecureTool.decryptConsumerCookie((String)jsdata3);
                JSONObject json = JSON.parseObject((String)content);
                if (new Date().getTime() - json.getLong("time") < 86400000L) {
                    return json.getLong("cid");
                }
            }
        }
        return null;
    }

    public static String parseIp(HttpServletRequest request) {
        String[] ips;
        int size;
        String ip = request.getHeader("x-forwarded-for");
        if (ip != null && ip.trim().length() > 0 && (size = (ips = ip.trim().split(",")).length) > 0) {
            ip = ips[size - 1].trim();
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Cdn-Src-Ip");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.startsWith("0:0:0:0")) {
            ip = LOCALHOST_IP;
        }
        return ip;
    }

    public static Map<String, String> parseCookies(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        HashMap cookieMap = Maps.newHashMap();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                cookieMap.put(cookie.getName(), cookie.getValue());
            }
        }
        return cookieMap;
    }
}

