package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.order.center.api.dto.ConsumerExchangeRecordDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/9/30.
 */
public interface RemoteConsumerExchangeRecordService {
    
	/**
	 * 插入兑换记录
	 * @param consumerExchangeRecordDto
	 * @return
     */
	DubboResult<ConsumerExchangeRecordDto> insert(ConsumerExchangeRecordDto consumerExchangeRecordDto);
	
	/**
	 * 根据多个参数条件，获取一条兑换记录
	 * map中包含参数可以为id、consumerId、type、relationId、switchs、overDue、json
	 * 其中consumerId是必传参数，否则直接返回null
	 * @param map
	 * @return
     */
	DubboResult<ConsumerExchangeRecordDto> selectOneByMapCondition(Map<String,Object> map);
	
	/**
	 * 根据多个参数条件，获取兑换记录--无分页
	 * map中包含参数可以为consumerId、type、relationId、switchs、overDue、json
	 * 其中consumerId是必传参数，否则直接返回null
	 * @param map
	 * @return
     */
	DubboResult<List<ConsumerExchangeRecordDto>> selectListByMapCondition(Map<String,Object> map);
	
	/**
	 * 根据多个参数条件，获取兑换记录--有分页
	 * map中包含参数可以为consumerId、type、relationId、switchs、overDue、json、start、pageSize
	 * 其中consumerId是必传参数，否则直接返回null
	 * @param map
	 * @return
     */
	DubboResult<List<ConsumerExchangeRecordDto>> selectPageListByMapCondition(Map<String,Object> map);
	
	/**
	 * 分页查询不包含福袋没有过期的兑换记录
	 * @param consumerId
	 * @param start
	 * @param pageSize
	 * @return
	 */
	DubboResult<List<ConsumerExchangeRecordDto>> selectValidWithoutFD(Long consumerId, int start, int pageSize);
	
	/**
	 * 分页查询不包含福袋已过期的兑换记录（90天内）
	 * @param consumerId
	 * @param start
	 * @param pageSize
	 * @return
	 */
	DubboResult<List<ConsumerExchangeRecordDto>> selectInvalidWithoutFD(Long consumerId, int start, int pageSize);
	
	/**
	 * 修改兑换记录信息
	 * @param dto
	 * @return
     */
	DubboResult<Boolean> update(ConsumerExchangeRecordDto dto);

	/**
	 *
	 * @param relationId
	 * @param type
	 * @param consumerId
	 * @return
	 */
	public DubboResult<ConsumerExchangeRecordDto> findByRelationIdAndType(Long relationId, Integer type, Long consumerId);

	/**
	 * 更新缓存在数据库中的json字段
	 * @param id
	 * @param json
	 * @param consumerId
     * @return
     */
	public DubboResult<Integer> updateJson(Long id,String json,long consumerId);


	/**
	 * 查询未过期记录 参数consumerId,offset,max
	 * @param map
	 * @return
     */
	public DubboResult<List<ConsumerExchangeRecordDto>> findConsumerExchangeRecordValid(Map<String, Object> map) ;

		/**
         *查询过期记录 参数consumerId,offset,max
         * @param map
         * @return
         */
	public DubboResult<List<ConsumerExchangeRecordDto>> findConsumerExchangeRecordInvalid(Map<String, Object> map) ;

	/**
	 * @param consumerId
	 * @return
	 */
	public DubboResult<ConsumerExchangeRecordDto> findOneRecordInvalid(long consumerId);

}
