package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 主订单异步审核接口
 * Created by yansen on 16/9/29.
 */
public interface RemoteMainOrderFlowworkService {
    /**
     * @param orderId
     * @return
     */
    public DubboResult<Void> doAuditPass(Long orderId);

    /**
     * @param orderId
     * @return
     */
    public DubboResult<Void> doAuditReject(Long orderId);


    /**
     * @param orderId
     * @param expressName
     * @param expressId
     * @return
     */
    public DubboResult<Boolean> executeObjectSend(Long orderId, String expressName, String expressId);

    /**
     * @param orderId
     * @param reason4consumer
     * @return
     */
    public DubboResult<Boolean> executeObjectCancel(Long orderId, String reason4consumer);

    /**
     * @param orderId
     * @param errorMassage
     * @return
     */
    DubboResult<Boolean> adminCanceOrder(Long orderId, String errorMassage);

    /**
     * @param orderId
     * @param deliverInfo
     * @return
     */
    DubboResult<Boolean> executeManualLotterySend(Long orderId, String deliverInfo);

    /**
     * @param orderId
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     * @return
     */
    DubboResult<Boolean> forceVirtual2SupplierSuccess(Long orderId, String error4admin, String error4developer, String error4consumer);

    /**
     * @param orderId
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     * @return
     */
    DubboResult<Boolean> forceVirtual2SupplierFail(Long orderId, String error4admin, String error4developer, String error4consumer);

    /**
     * @param orderId
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     * @return
     */
    DubboResult<Boolean> mngForceSupplierSuccess(Long orderId, String error4admin, String error4developer, String error4consumer);

    /**
     * @param orderId
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     * @return
     */
    DubboResult<Boolean> mngForceSupplierFail(Long orderId, String error4admin, String error4developer, String error4consumer);

    /**
     * @param orderId
     * @return
     */
    DubboResult<Boolean> killOrderMakeSuccess(Long orderId);

    /**
     *
     * @param orderId
     * @return
     */
    DubboResult<Boolean> killOrderMakeFail(Long orderId);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param allowInput
     * @param allowInputTips
     * @return
     */
    DubboResult<Boolean> updateAllowInputAndTips(Long orderId, Long consumerId, Boolean allowInput, String allowInputTips);
}
