package cn.com.duiba.order.center.api.dto;



import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

/**
 * 供应商订单
 */
public class SupplierOrderDto  implements Serializable{
	public static final String PREFIX_ORDER = "duiba";// 重复请求时给上游传递的订单号

	public static final String StatusCreate = "create";// 创建订单
	public static final String StatusSend = "send"; // 已经发送请求
	public static final String StatusSuccess = "success";// 处理成功
	public static final String StatusFail = "fail";// 处理失败

	public static final String StatusToDeliver = "to_deliver";// 实物兑换，待发货

	public static final int StatusIntCreate = 0;
	public static final int StatusIntSend = 1;
	public static final int StatusIntSuccess = 2;
	public static final int StatusIntFail = 3;
	public static final int StatusIntToDeliver = 4;
	private static final long serialVersionUID = 1761818458939631342L;

	private Long id;
	private Long orderId;
	private Long supplierProductId;
	private String status;
	private Integer statusInt;
	private String errorMessage;
	private String supplierInfo;
	private String supplierBizId;
	private String bizParams;
	private String bizData;
	private Date sendTime;

	private String duibaOrderNum;// 兑吧订单号 正常情况下=Orders.orderNum,多次向上游发起兑换请求是 会
	private Date gmtCreate;
	private Date gmtModified;

	/**
	 * 默认构造函数
	 */
	public SupplierOrderDto() {
		super();
	}

	/**
	 *
	 * @param id
     */
	public SupplierOrderDto(Long id) {
		this.id = id;
		this.gmtModified = new Date();
	}

	/**
	 *
	 * @param init4insert
     */
	public SupplierOrderDto(boolean init4insert) {
		if (init4insert) {
			status = StatusCreate;
			statusInt = StatusIntCreate;
			gmtCreate = new Date();
			gmtModified = gmtCreate;
		}
	}

	/**
	 *
	 * @param status
	 * @return
     */
	public static Integer statusToInt(String status) {
		if (StatusCreate.equals(status)) {
			return StatusIntCreate;
		} else if (StatusSend.equals(status)) {
			return StatusIntSend;
		} else if (StatusSuccess.equals(status)) {
			return StatusIntSuccess;
		} else if (StatusFail.equals(status)) {
			return StatusIntFail;
		} else if (StatusToDeliver.equals(status)) {
			return StatusIntToDeliver;
		}

		return -1;
	}

	/**
	 *
	 * @return
     */
	public static synchronized String generate(){
		Date date=new Date();
		SimpleDateFormat format=new SimpleDateFormat("yyyyMMddHHmmssSSS");
		
		long step=10000;
		int timesInt=new Random().nextInt(100);
		Long atomic=new Long(timesInt*step);
		
		String f=format.format(date);
		
		Long value=++atomic;
		if(atomic>=10000000){
			atomic=new Long(timesInt*step);
		}
		String v=value.toString();
		while(v.length()<8){
			v="0"+v;
		}
		
		return PREFIX_ORDER+f+v;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getOrderId() {
		return orderId;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public Long getSupplierProductId() {
		return supplierProductId;
	}

	public void setSupplierProductId(Long supplierProductId) {
		this.supplierProductId = supplierProductId;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
		this.statusInt=statusToInt(status);
	}

	public Integer getStatusInt() {
		return statusInt;
	}

	public void setStatusInt(Integer statusInt) {
		this.statusInt = statusInt;
	}

	public String getErrorMessage() {
		return errorMessage;
	}

	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}

	public String getSupplierInfo() {
		return supplierInfo;
	}

	public void setSupplierInfo(String supplierInfo) {
		this.supplierInfo = supplierInfo;
	}

	public String getSupplierBizId() {
		return supplierBizId;
	}

	public void setSupplierBizId(String supplierBizId) {
		this.supplierBizId = supplierBizId;
	}

	public String getBizParams() {
		return bizParams;
	}

	public void setBizParams(String bizParams) {
		this.bizParams = bizParams;
	}

	public String getBizData() {
		return bizData;
	}

	public void setBizData(String bizData) {
		this.bizData = bizData;
	}

	public Date getSendTime() {
		return sendTime;
	}

	public void setSendTime(Date sendTime) {
		this.sendTime = sendTime;
	}

	public String getDuibaOrderNum() {
		return duibaOrderNum;
	}

	public void setDuibaOrderNum(String duibaOrderNum) {
		this.duibaOrderNum = duibaOrderNum;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

}
