package cn.com.duiba.order.center.api.dto;


import java.io.Serializable;
import java.util.Date;

/**
 * @author yansen
 */
public class SupplierProductDto implements Serializable{
	private static final long serialVersionUID = -7631453749994277342L;

	public static final String SupplierQBTencent = "qb-tencent";// Q币充值 腾讯官方
	public static final String SupplierQBEnlian="qb-enlian" ;//Q币充值 恩连
	public static final String SupplierPhonebillLiulianggo="phonebill-go" ;//流量购话费充值
	public static final String SupplierCallflowGo="callflow-go"; //流量购
	public static final String SupplierAlipayCodeHuichang="alipaycode-huichang" ;//汇畅支付宝充值码充值
	public static final String SupplierPhonebillGyjx="phonebill-gyjx"; //高阳捷迅话费充值
	public static final String SupplierAlipayFastOufei="alipayfast-oufei"; //欧飞支付宝快速充值
	public static final String SupplierGameCardGyjx="gamecard-gyjx" ;//高阳捷迅游戏点卡充值
	public static final String SupplierPhoneflowOufei="phoneflow-oufei";//欧飞手机流量充值
	public static final String SupplierPhonebillSududa="phonebill-sududa"; //速度达小额话费
	public static final String SupplierPhonebillOufei="phonebill-oufei"; //欧飞小额话费

	public static final String SupplierDuibaObject="duiba-object"; //兑换实物兑换
	public static final String SupplierDeveloperObject="developer-object" ;//兑换实物兑换
	public static final String SupplierDeveloperVirtual="developer-virtual";//兑换虚拟商品

	public static final String SupplierDuibaCoupon="duiba-coupon"; //兑换优惠券兑换
	public static final String SupplierDeveloperCoupon="developer-coupon"; //开发者自有优惠券

	public static final String SupplierAlipayOfficial="alipay-official"; //支付宝官方转账
	public static final String SupplierThirdPayOfficial="thirdpay-zhongxiang"; //第三方支付宝转账--众想
	public static final String SupplierQBGouka="qb-gouka";

	public static final String SupplierPhonebillLianlian="phonebill-lianlian-new" ;//话费连连充值

	public static final String SupplierPhonebillNewLianlian="phonebill-lianlian-new-platform" ;//话费连连充值

	public static final String SupplierPhoneflowMoPin="phoneflow-mopin";//魔品手机流量充值
	

	private Long id;
	private String supplier;
	private String productId;
	private String name;
	private String mobile ;//运营商
	private String province; //省份
	private Integer facePrice;
	private Integer actualPrice;
	private Integer supplierPrice ;//供应商提供给我们的价格
	private Boolean enable;
	private String gameId;
	private Boolean duibaSwitch ;
	private String extra ;//额外参数

	//此参数不保存到数据库，只是作为临时保存数据使用
	private Integer actualPrice4Order;


	private Date gmtCreate;
	private Date gmtModified;

	/**
	 * 默认构造函数
	 */
	public SupplierProductDto() {
		super();
	}

	/**
	 *
	 * @param id
     */
	public SupplierProductDto(Long id) {
		this.id = id;
		this.gmtModified = new Date();
	}

	/**
	 *
	 * @param init4insert
     */
	public SupplierProductDto(boolean init4insert) {
		if (init4insert) {
			enable = true;
			facePrice = 0;
			actualPrice = 0;
			duibaSwitch = false;
			gmtCreate = new Date();
			gmtModified = gmtCreate;
		}
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getSupplier() {
		return supplier;
	}

	public void setSupplier(String supplier) {
		this.supplier = supplier;
	}

	public String getProductId() {
		return productId;
	}

	public void setProductId(String productId) {
		this.productId = productId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getMobile() {
		return mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public Integer getFacePrice() {
		return facePrice;
	}

	public void setFacePrice(Integer facePrice) {
		this.facePrice = facePrice;
	}

	public Integer getActualPrice() {
		return actualPrice;
	}

	public void setActualPrice(Integer actualPrice) {
		this.actualPrice = actualPrice;
	}

	public Integer getSupplierPrice() {
		return supplierPrice;
	}

	public void setSupplierPrice(Integer supplierPrice) {
		this.supplierPrice = supplierPrice;
	}

	public Boolean getEnable() {
		return enable;
	}

	public void setEnable(Boolean enable) {
		this.enable = enable;
	}

	public String getGameId() {
		return gameId;
	}

	public void setGameId(String gameId) {
		this.gameId = gameId;
	}

	public Boolean getDuibaSwitch() {
		return duibaSwitch;
	}

	public void setDuibaSwitch(Boolean duibaSwitch) {
		this.duibaSwitch = duibaSwitch;
	}

	public String getExtra() {
		return extra;
	}

	public void setExtra(String extra) {
		this.extra = extra;
	}

	public Integer getActualPrice4Order() {
		return actualPrice4Order;
	}

	public void setActualPrice4Order(Integer actualPrice4Order) {
		this.actualPrice4Order = actualPrice4Order;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

}
