package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.order.center.api.dto.ConsumerLimitRecordDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

public interface RemoteConsumerExchangeLimitService {

	DubboResult<Integer> consumerLimitRecordOnlyInsert(ConsumerLimitRecordDto record);
	
	DubboResult<Integer> consumerLimitRecordOnlyDelete(Long consumerId, Long appItemId, Long itemId, Long orderId);

	DubboResult<Integer> deleteByIds(List<Long> ids);

	DubboResult<List<ConsumerLimitRecordDto>> findPageByOverdue(Date overdue, Integer start, Integer pageSize);

	DubboResult<Long> findCountByOverdue(Date date);

	DubboResult<Integer> countByItemKey(Long consumerId, String itemKey);
}
