package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 主订单--开发者维度拆分表--基础接口
 * @author zhaodongxue
 *
 */
public interface RemoteMirrorOrderSimpleService {

	/**
	 *
	 * @param orderId
	 * @param appId
	 * @return
     */
	DubboResult<OrdersDto> findByOrderId(Long orderId, Long appId);

	/**
	 *
	 * @param ids
	 * @param appId
     * @return
     */
	DubboResult<List<OrdersDto>> findByOrderIds(List<Long> ids, Long appId);

	/**
	 *
	 * @param orderNum
	 * @param appId
     * @return
     */
	DubboResult<OrdersDto> findByOrderNum(String orderNum, Long appId);

	/**
	 *
	 * @param orderNums
	 * @param appId
     * @return
     */
	DubboResult<List<OrdersDto>> findByOrderNums(List<String> orderNums, Long appId);

	/**
	 *
	 * @param appId
	 * @param developerBizId
     * @return
     */
	DubboResult<OrdersDto> findByAppAndDeveloperBizId(Long appId, String developerBizId);
}
