package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.order.center.api.dto.AmbSubOrdersDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 加钱购子订单接口
 * Created by yansen on 16/9/26.
 */
public interface RemoteAmbSubOrdersService {
    /**
     *
     * @param subId
     * @return
     */
    public DubboResult<Integer> updateSettleStatusWaitSettleBySubId(Long subId);

    /**
     *
     * @param subId
     * @return
     */
    public DubboResult<AmbSubOrdersDto> findSubOrderById(Long subId);

    /**
     *
     * @param subId
     * @return
     */
    public DubboResult<Integer> updateSettleStatusSettleBySubId(Long subId);

    /**
     *
     * @param subId
     * @param remark
     * @return
     */
    public DubboResult<Integer> updateRemarkBySubId(Long subId, String remark);

    /**
     *
     * @param subId
     * @param consumerPayBackPrice
     * @return
     */
    public DubboResult<Integer> updateSettleStatusNoneBySubId(Long subId, Long consumerPayBackPrice);

    /**
     *
     * @param subId
     * @return
     */
    public DubboResult<Integer> updateShipStatus4ReceivedAtCreate(Long subId);

    /**
     *
     * @param subId
     * @return
     */
    DubboResult<Integer> updateShipStatus4WaitShip(Long subId);

    /**
     *
     * @param subId
     * @return
     */
    DubboResult<Integer> updateShipStatus4Shiped(Long subId);
    /**
     * 子订单确认收货
     * @param orderId
     * @param consumerId
     * @return
     */
    DubboResult<Void> consumerConfirmReceived(Long orderId,Long consumerId);


}
