package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.SupplierOrderDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by yansen on 16/9/26.
 */
@AdvancedFeignClient
public interface RemoteSupplierOrdersService {
    /**
     *
     * @param supplierOrderDto
     * @return
     */
    public DubboResult<SupplierOrderDto> insert(SupplierOrderDto supplierOrderDto);

    /**
     *
     * @param supplierOrderDto
     * @return
     */
    public DubboResult<Void> update(SupplierOrderDto supplierOrderDto);

    /**
     *
     * @param id
     * @return
     */
    public DubboResult<SupplierOrderDto> find(Long id);

    /**
     *
     * @param duibaOrderNum
     * @return
     */
    public DubboResult<List<SupplierOrderDto>> findAllByDuibaOrderNum(String duibaOrderNum);

    /**
     *
     * @param duibaOrderNum
     * @return
     */
    public DubboResult<SupplierOrderDto> findByDuibaOrderNum(String duibaOrderNum);

    /**
     *
     * @param idList
     * @return
     */
    DubboResult<List<SupplierOrderDto>> findALLByIdList(List<Long> idList);
}
