package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.ConsumerExchangeLimitDto;
import cn.com.duiba.order.center.api.dto.ConsumerLimitRecordMultiDto;
import cn.com.duiba.order.center.api.paramquery.ConsumerExchangeLimitParams;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by yansen on 17/5/15.
 */
@AdvancedFeignClient
public interface RemoteConsumerLimitRecordService {

    /**
     *
     * @param consumerLimitRecordMultiDto
     * @return
     */
    public DubboResult<ConsumerLimitRecordMultiDto> insert(ConsumerLimitRecordMultiDto consumerLimitRecordMultiDto);

    /**
     *
     * @param sourceId
     * @param sourceType
     * @return
     */
    public DubboResult<Integer> deleteBySource(Long sourceId, String sourceType);

    /**
     *
     * @param consumerExchangeLimitParams
     * @return
     */
    public DubboResult<Integer> countByItemKey(ConsumerExchangeLimitParams consumerExchangeLimitParams);

    /**
     *
     * @param consumerExchangeLimitParams
     * @return
     */
    public DubboResult<Integer> countByItemKeyAndGmtCreate(ConsumerExchangeLimitParams consumerExchangeLimitParams);

    /**
     *
     * @param consumerExchangeLimitParams
     * @return
     */
    public DubboResult<Integer> countByItemSubKey(ConsumerExchangeLimitParams consumerExchangeLimitParams);

    /**
     *
     * @param consumerExchangeLimitParams
     * @return
     */
    public DubboResult<List<ConsumerExchangeLimitDto>> countByInItemKeySubKey(ConsumerExchangeLimitParams consumerExchangeLimitParams);

    /**
     *
     * @param consumerExchangeLimitParams
     * @return
     */
    public DubboResult<List<ConsumerExchangeLimitDto>> countByInItemKeySubKeyAndGmtCreate(ConsumerExchangeLimitParams consumerExchangeLimitParams);

}
