package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.MailaItemDto;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * Created by yansen on 16/9/22.
 * 主订单--用户维度拆分表--基础接口
 */
@AdvancedFeignClient
public interface RemoteConsumerOrderSimpleService {


    /**
     * 根据订单id和用户id查询订单
     * @param id
     * @param consumerId
     * @return
     */
    @RequestMapping("/findByIdAndCid")
    public DubboResult<OrdersDto> findById(Long id, Long consumerId);
    
    /**
     * 根据多个id查询订单--警告调用者list长度不宜过长
     * @param ids
     * @param consumerId
     * @return
     */
    DubboResult<List<OrdersDto>> findByIds(List<Long> ids, Long consumerId);
    
    /**
     * 根据多个id查询订单，返回数据和sequence顺序一致--警告调用者list长度不宜过长
     * @param ids
     * @param sequence id逗号隔开，返回数据的顺序和sequence顺序一致
     * @param consumerId
     * @return
     */
    DubboResult<List<OrdersDto>> findByIdsInSequence(List<Long> ids, String sequence, Long consumerId);

    /**
     * 根据订单唯一编号查询订单
     * @param orderNum
     * @return
     */
    public DubboResult<OrdersDto> findByOrderNum(String orderNum);

    /**
     * 通过for update的方式查询订单
     * @param orderId
     * @param consumerId
     * @return
     */
    public DubboResult<OrdersDto> select4updatelock(Long orderId, Long consumerId);

    /**
     * 根据订单id查询订单
     * @param id
     * @return
     */
    DubboResult<OrdersDto> findById(Long id);
    
    /**
     * 用户和商品维度，查询订单--商品数量最大20
     * @param consumerId
     * @param itemIds
     * @return
     */
    DubboResult<List<MailaItemDto>> findByItem(Long consumerId, List<Long> itemIds);

	/**
     * 订单同步的消息,防止出现因为订单消息丢失导致的订单不同步
     * @param orderId
     * @param cousumerId
     * @return
     */
    void  syncOrder(Long orderId,Long cousumerId);
}
