package cn.com.duiba.order.center.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by yansen on 17/5/15.
 */
public class ConsumerLimitRecordMultiDto implements Serializable{
    private static final long serialVersionUID = 4863611014054537097L;
    public static final String SourceTypeOrder = "order"; // 主订单
    public static final String SourceTypeTurntable = "turntable"; // 幸运转盘
    public static final String SourceTypeSingleLottery = "singleLottery"; // 单品抽奖
    public static final String SourceTypeManualLottery = "manualLottery"; // 手动开奖
    public static final String SourceTypeHdtool = "hdtool"; // 活动工具

    private Long id;
    private Long consumerId;
    private Long appItemId;
    private Long itemId;
    private String itemKey;
    private String subKey;
    private Long sourceId;
    private String sourceType;
    private Date gmtCreate;
    private Date gmtModified;

    public ConsumerLimitRecordMultiDto() {

    }

    /**
     *
     * @param id
     */
    public ConsumerLimitRecordMultiDto(Long id) {
        this.id = id;
        this.gmtModified = new Date();
    }

    /**
     *
     * @param init4insert
     */
    public ConsumerLimitRecordMultiDto(boolean init4insert) {
        if (init4insert) {
            gmtCreate = new Date();
            gmtModified = gmtCreate;
        }
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemKey() {
        return itemKey;
    }

    public void setItemKey(String itemKey) {
        this.itemKey = itemKey;
    }

    /**
     *
     * @param appItemId
     * @param itemId
     */
    public void setItemKey(Long appItemId, Long itemId) {
        String key = null;
        if (itemId != null) {
            key = itemId.toString();
        } else if (appItemId != null) {
            key = appItemId.toString();
        }
        if (key == null) {
            throw new RuntimeException("setItemKeyHash error");
        }
        this.itemKey = key;
    }

    public String getSubKey() {
        return subKey;
    }

    public void setSubKey(String subKey) {
        this.subKey = subKey;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
