package cn.com.duiba.order.center.api.dto;

import cn.com.duiba.wolf.utils.MirrorEqualsUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author JunAngLiu
 * @Title: HaidilaoOrderDto
 * @Description:
 * * @date 2018/6/2911:18
 */
public class HaidilaoOrderDto implements Serializable {

    private static final long serialVersionUID = -2992598425727803907L;

    public static final String StatusCreate = "create";
    public static final String StatusSuccess = "success";
    public static final String StatusFAil = "fail";
    public static final String StatusConsumeSuccess = "consume_success";
    public static final String StatusConsumeFail = "consume_fail";

    public static final String StatusAfterSend = "after_send";

    public static final String FlowworkStageOrderCreateStart = "Create-started";


    public static final String AuditStatusNotNeed = null;
    public static final String AuditStatusWait = "wait";
    public static final String AuditStatusPass = "pass";
    public static final String AuditStatusReject = "reject";



    public static final String PayStatusPrereduce = "prereduce";// 预扣费
    public static final String PayStatusSuccess = "successs"; // 扣费成功，交易完成
    public static final String PayStatusPayback = "payback"; // 交易失败，费用已反冲
    public static final String PayStatusUnknowPay = "unknown_pay";  //未知的支付状态
    public static final String PayStatusWaitPay = "wait_pay";  //待付款
    public static final String PayStatusNone = "none";  //无须付款，或者无付款信息

    public static final String type_coupon = "coupon";  //无须付款，或者无付款信息


    public static final String ChargeModeMall = "mall";
    public static final String ChargeModeApi = "api";
    public static final String ChargeModeTurntable = "turntable";// 来自大转盘订单
    public static final String ChargeModeSingleLottery = "singlelottery"; //来自单品抽奖
    public static final String ChargeModeManualLottery = "manuallottery";//手工开奖
    public static final String ChargeModeHdtool = "hdtool"; //活动工具
    public static final String ChargeModeGame = "game"; //游戏活动
    public static final String ChargeModeQuestion = "question"; //答题活动
    public static final String ChargeModeQuizz = "quizz";//测试题活动
    public static final String ChargeModeSeckill = "seckill"; //秒杀活动
    public static final String ChargeModeNgame = "ngame"; //游戏活动
    public static final String ChargeModeGuess = "guess"; //游戏活动
    public static final String ChargeModeActivity = "activity";//新活动，今日必抢等等
    public static final String CHARGE_MODE_HAPPY_CODE = "happyCode";//开心码

    public static final int NotifyStatusSuccess = 999;// 通知成功
    public static final int MaxNotifyTimes = 5;// 最大通知次数

    public static final int FailTypeSupplier = 1;// 上游兑换失败
    public static final int FailTypeDeveloperServerErr = 2;// 开发者服务器异常
    public static final int FailTypeDeveloperFeedback = 3;// 开发者反馈失败：扣积分失败 积分不足等
    public static final int FailTypeAuditReject = 4;// 审核拒绝

    public static final int RelationTypeDefault = 0; // 普通订单
    public static final int RelationTypeActivity = 1; // 专题活动订单
    public static final int RelationTypeSingleLottery = 2; // 单品抽奖
    public static final int RelationTypeTurntable = 3;// 大转盘订单
    public static final int RelationTypeManualLottery = 4;//手动开奖
    public static final int RelationTypeHdtool = 5;//活动工具
    public static final int RelationTypeGame = 6;//游戏活动
    public static final int RelationTypeSecondsKill = 7;//秒杀专题
    public static final int RelationTypeQuestion = 8;//答题活动
    public static final int RelationTypeQuizz = 10;//测试题活动
    public static final int RelationTypeSeckill = 9;//秒杀活动
    public static final int RelationTypeNgame = 11;//新游戏
    public static final int RelationTypeGuess = 12;//竞猜活动
    public static final int RelationTypeRob = 13;//今日必抢
    public static final int RelationTypeCreditGame = 14; //积分游戏
    public static final int RelationTypeLittleGame = 15; //小游戏
    public static final int RelationTypePlugin = 16;//插件活动
    public static final int RelationTypeElasticGifts = 17;//弹层活动
    public static final int RelationTypeSign = 18;//签到活动
    public static final int RelationTypeMailaRob=19;//麦啦今日必抢
    public static final int RELATION_TYPE_HAPPY_CODE = 20;//开心码

    public static final String DuibaPayStatusNone = "none";//没有支付需求
    public static final String DuibaPayStatusPrereduce = "prereduce";// 预扣费
    public static final String DuibaPayStatusSuccess = "success"; // 扣费成功，交易完成
    public static final String DuibaPayStatusPayback = "payback"; // 交易失败，费用已反冲
    public static final String DuibaPayStatusUnknowPay = "unknown_pay";  //未知的支付状态
    public static final String DuibaPayStatusWaitPay = "wait_pay";  //待付款

    //none | wait_pay | pay_success | pay_back | canceled | success
    public static final String ConsumerPayStatusNone = "none";
    public static final String ConsumerPayStatusWaitPay = "wait_pay";
    public static final String ConsumerPayStatusPaySuccess = "pay_success";
    public static final String ConsumerPayStatusPayBack = "pay_back";
    public static final String ConsumerPayStatusCanceled = "canceled";
    public static final String ConsumerPayStatusSuccess = "success";

    /**
     * 加钱购
     */
    public static final String SubOrderTypeAmb = "amb";
    /**
     * 活动工具
     */
    public static final String SubOrderTypeHdtool = "hdtool";
    /**
     * 插件
     */
    public static final String SubOrderTypePlugin = "plugin";
    /**
     * 游戏
     */
    public static final String SubOrderTypeNgame = "ngame";
    /**
     * 签到
     */
    public static final String SubOrderTypeSign = "sign";
    /**
     * 单品抽奖
     */
    public static final String SubOrderTypeSinglelottery = "singlelottery";
    /**
     * 开心码
     */
    public static final String SubOrderTypeHappyCode = "happycode";
    /**
     * 手动开奖
     */
    public static final String SubOrderTypeManuallottery = "manuallottery";
    /**
     * 答题
     */
    public static final String SubOrderTypeQuestion = "question";
    /**
     * 测试题
     */
    public static final String SubOrderTypeQuizz = "quizz";
    /**
     * 竞猜
     */
    public static final String SubOrderTypeGuess = "guess";




    public static final Integer try_again_count = 1;

    public static final Integer try_again_interval_time = 50;

    public static final String SUB_ORDER_TYPE = "amb";    // 子订单为加钱购

    public static final String MOBIKE_CREDITS="bizCredits";

    public static final String IS_RESTORE_BUGDET="isRestoreBudget";


    private Long id;
    private String orderNum;// 订单号
    private Long developerId;
    private Long appId;
    private Long consumerId;
    private Long itemId;
    private Long appItemId;
    private Long couponId;
    private String type;// qb phonebill coupon
    /**
     * 使用GoodsTypeEnum的gtype类型常量
     */
    private Integer typeInt;
    private Integer facePrice;
    private Integer actualPrice;
    private Long credits;// 消耗的积分数
    private Integer quantity;
    private String bizParams; // 业务参数，比如qq号码

    private String status;// 处理中 成功 失败
    private String errorMessage;
    private String failReason; // 失败原因，主要是给用户看的

    private String error4Consumer;// 给用户的出错提示
    private String error4Developer; // 给开发者的出错提示
    private String error4Admin;// 给兑吧管理员的出错提示

    private String payStatus;// 预扣费 扣费成功 已反冲
    private String auditStatus;

    private Boolean allowInputAgain; // 是否允许用户再次填写，重新兑换
    private String allowInputTips; // 允许用户再次填写时，给用户的提示语

    private Date auditTime; // 审核时间

    private String developerBizId; // 开发者的业务id

    private Long supplierOrderId;

    private Date finishTime;// 订单结束时间

    private String chargeMode;// 充值模式 api mall 默认mall
    private String brief;

    private String ip;
    private Integer notify;// 通知状态 null 1-通知次数

    private Date lastSendTime;// 上游请求发送时间
    private Integer failType; // 失败类型 0-成功 1-上游失败 2-开发者服务器异常 3-开发者反馈失败 4审核拒绝

    private Long relationId;// 关联对象id，如果ChargeMode=turntable，则此为大转盘订单id
    private Integer relationType;

    private Date gmtCreate;
    private Date gmtModified;

    private Integer duibaActualPrice;
    private String duibaPayStatus;

    private Long subOrderId;// 子订单ID
    private String subOrderType;// 子订单类型 amb:加钱购
    private String consumerPayStatus;// 用户付款状态 none | wait_pay | pay_success |
    // pay_back | canceled | success
    private Long consumerPayPrice;// 用户支付金额
    private Long consumerPayBackPrice;//

    private String flowworkStage;

    private Integer statusInt;
    private Integer auditStatusInt;
    private Integer payStatusInt;

    private String tableName;//表名，数据库无此字段

    //额外信息,目前用来存储了摩拜的积分信息
    private String extraInfo;



    /**
     * 新增字段
     * */
    private Long freight;//运费

    private Long totalPromoPrice;// 总的优惠价格

    /**
     *子订单 入参
     * */
    private List<OrderItemDto> orderItemDtoList;

    public Long getFreight() {
        return freight;
    }

    public void setFreight(Long freight) {
        this.freight = freight;
    }

    public Long getTotalPromoPrice() {
        return totalPromoPrice;
    }

    public void setTotalPromoPrice(Long totalPromoPrice) {
        this.totalPromoPrice = totalPromoPrice;
    }

    public List<OrderItemDto> getOrderItemDtoList() {
        return orderItemDtoList;
    }

    public void setOrderItemDtoList(List<OrderItemDto> orderItemDtoList) {
        this.orderItemDtoList = orderItemDtoList;
    }

    /**
     * 默认构造函数
     */
    public HaidilaoOrderDto() {
    }

    /**
     *
     * @param id
     */
    public HaidilaoOrderDto(Long id) {
        this.id = id;
        this.gmtModified = new Date();
    }

    /**
     *
     * @param init4insert
     */
    public HaidilaoOrderDto(boolean init4insert) {
        if (init4insert) {
            failType = 0;
            allowInputAgain = false;
            facePrice = 0;
            auditStatus = AuditStatusNotNeed;
            relationType = RelationTypeDefault;

            consumerPayPrice = 0l;
            consumerPayBackPrice = 0l;

            duibaActualPrice = 0;

            flowworkStage = FlowworkStageOrderCreateStart;

            gmtCreate = new Date();
            gmtModified = gmtCreate;
        }
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public Long getDeveloperId() {
        return developerId;
    }

    public void setDeveloperId(Long developerId) {
        this.developerId = developerId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Long getCouponId() {
        return couponId;
    }

    public void setCouponId(Long couponId) {
        this.couponId = couponId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getFacePrice() {
        return facePrice;
    }

    public void setFacePrice(Integer facePrice) {
        this.facePrice = facePrice;
    }

    public Integer getActualPrice() {
        return actualPrice;
    }

    public void setActualPrice(Integer actualPrice) {
        this.actualPrice = actualPrice;
    }

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public String getBizParams() {
        return bizParams;
    }

    public void setBizParams(String bizParams) {
        this.bizParams = bizParams;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }


    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getFailReason() {
        return failReason;
    }

    public void setFailReason(String failReason) {
        this.failReason = failReason;
    }

    public String getError4Consumer() {
        return error4Consumer;
    }

    public void setError4Consumer(String error4Consumer) {
        if (error4Consumer != null && error4Consumer.length() > 255) {
            this.error4Consumer = error4Consumer.substring(0, 255);
        } else {
            this.error4Consumer = error4Consumer;
        }
    }

    public String getError4Developer() {
        return error4Developer;
    }

    public void setError4Developer(String error4Developer) {
        if (error4Developer != null && error4Developer.length() > 255) {
            this.error4Developer = error4Developer.substring(0, 255);
        } else {
            this.error4Developer = error4Developer;
        }
    }

    public String getError4Admin() {
        return error4Admin;
    }

    public void setError4Admin(String error4Admin) {
        if (error4Admin != null && error4Admin.length() > 255) {
            this.error4Admin = error4Admin.substring(0, 255);
        } else {
            this.error4Admin = error4Admin;
        }
    }

    public String getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(String payStatus) {
        this.payStatus = payStatus;
    }

    public String getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(String auditStatus) {
        this.auditStatus = auditStatus;
    }


    public Boolean getAllowInputAgain() {
        return allowInputAgain;
    }

    public void setAllowInputAgain(Boolean allowInputAgain) {
        this.allowInputAgain = allowInputAgain;
    }

    public String getAllowInputTips() {
        return allowInputTips;
    }

    public void setAllowInputTips(String allowInputTips) {
        this.allowInputTips = allowInputTips;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public String getDeveloperBizId() {
        return developerBizId;
    }

    public void setDeveloperBizId(String developerBizId) {
        this.developerBizId = developerBizId;
    }

    public Long getSupplierOrderId() {
        return supplierOrderId;
    }

    public void setSupplierOrderId(Long supplierOrderId) {
        this.supplierOrderId = supplierOrderId;
    }

    public Date getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    public String getChargeMode() {
        return chargeMode;
    }

    public void setChargeMode(String chargeMode) {
        this.chargeMode = chargeMode;
    }

    public String getBrief() {
        return brief;
    }

    public void setBrief(String brief) {
        this.brief = brief;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Integer getNotify() {
        return notify;
    }

    public void setNotify(Integer notify) {
        this.notify = notify;
    }

    public Date getLastSendTime() {
        return lastSendTime;
    }

    public void setLastSendTime(Date lastSendTime) {
        this.lastSendTime = lastSendTime;
    }

    public Integer getFailType() {
        return failType;
    }

    public void setFailType(Integer failType) {
        this.failType = failType;
    }

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getRelationType() {
        return relationType;
    }

    public void setRelationType(Integer relationType) {
        this.relationType = relationType;
    }

    /**
     * 是否像镜像一样字段数据完全相同
     *
     * @param order
     * @return
     */
    public boolean equalsMirror(OrdersDto order) {
        return MirrorEqualsUtils.mirrorEquals(this, order);
    }

    public Integer getDuibaActualPrice() {
        return duibaActualPrice;
    }

    public void setDuibaActualPrice(Integer duibaActualPrice) {
        this.duibaActualPrice = duibaActualPrice;
    }

    public String getDuibaPayStatus() {
        return duibaPayStatus;
    }

    public void setDuibaPayStatus(String duibaPayStatus) {
        this.duibaPayStatus = duibaPayStatus;
    }

    public Long getSubOrderId() {
        return subOrderId;
    }

    public void setSubOrderId(Long subOrderId) {
        this.subOrderId = subOrderId;
    }

    public String getConsumerPayStatus() {
        return consumerPayStatus;
    }

    public void setConsumerPayStatus(String consumerPayStatus) {
        this.consumerPayStatus = consumerPayStatus;
    }

    public Long getConsumerPayPrice() {
        return consumerPayPrice;
    }

    public void setConsumerPayPrice(Long consumerPayPrice) {
        this.consumerPayPrice = consumerPayPrice;
    }

    public Long getConsumerPayBackPrice() {
        return consumerPayBackPrice;
    }

    public String getSubOrderType() {
        return subOrderType;
    }

    public void setSubOrderType(String subOrderType) {
        this.subOrderType = subOrderType;
    }

    public void setConsumerPayBackPrice(Long consumerPayBackPrice) {
        this.consumerPayBackPrice = consumerPayBackPrice;
    }

    public String getFlowworkStage() {
        return flowworkStage;
    }

    public void setFlowworkStage(String flowworkStage) {
        this.flowworkStage = flowworkStage;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }


    public Integer getTypeInt() {
        return typeInt;
    }


    public void setTypeInt(Integer typeInt) {
        this.typeInt = typeInt;
    }

    public Integer getStatusInt() {
        return statusInt;
    }

    public void setStatusInt(Integer statusInt) {
        this.statusInt = statusInt;
    }

    public Integer getAuditStatusInt() {
        return auditStatusInt;
    }

    public void setAuditStatusInt(Integer auditStatusInt) {
        this.auditStatusInt = auditStatusInt;
    }

    public Integer getPayStatusInt() {
        return payStatusInt;
    }

    public void setPayStatusInt(Integer payStatusInt) {
        this.payStatusInt = payStatusInt;
    }

    public String getExtraInfo() {
        return extraInfo;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }


}
