/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.api.constant;

import cn.com.duiba.order.center.api.constant.AmbPostSalesStatusEnum;
import cn.com.duiba.order.center.api.constant.AmbSubOrderStatusEnum;
import cn.com.duiba.order.center.api.constant.ConsumerPayEnum;
import cn.com.duiba.order.center.api.constant.OrderAuditStatusEnum;
import cn.com.duiba.order.center.api.constant.OrderStatusEnum;
import cn.com.duiba.order.center.api.constant.SupplierOrderStatus;
import cn.com.duiba.order.center.api.dto.AmbPostsaleOrdersDto;
import cn.com.duiba.order.center.api.dto.AmbSubOrdersDto;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.dto.SupplierOrderDto;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public enum OrderStatus4ConsumerEnum {
    CREATE("\u9352\u6d98\u7f13\u6d93\ufffd"),
    WAIT_PAY("\u5bf0\u546e\u656e\u6d60\ufffd"),
    WAIT_AUDIT("\u5bf0\u546d\ue178\u93cd\ufffd"),
    AUDIT_FAIL("\u7039\u2103\u7273\u6fb6\u8fab\u89e6"),
    DEALING("\u6fb6\u52ed\u608a\u6d93\ufffd"),
    WAIT_SHIP("\u5bf0\u546d\u5f42\u7490\ufffd"),
    AFTER_SEND("\u5bb8\u63d2\u5f42\u7490\ufffd"),
    RECEIVED("\u5bb8\u53c9\u6579\u7490\ufffd"),
    WAIT_POST("\u935e\ue1bc\u6097\u5bf0\u546d\ue629\u941e\ufffd"),
    REJECT_REFUND("\u93b7\u6394\u7cb7\u935e\ue1bc\u6097"),
    AGREE_REFUND("\u935a\u5c7e\u5270\u935e\ue1bc\u6097"),
    REFUNDING("\u95ab\ufffd\u5a06\u53e5\u8151"),
    SUCCESS("\u6d5c\u3086\u69d7\u93b4\u612c\u59db"),
    FAIL("\u6d5c\u3086\u69d7\u934f\u62bd\u68f4"),
    UNKNOWN("\u6fb6\u52ed\u608a\u6d93\ufffd");

    private String desc;

    private OrderStatus4ConsumerEnum(String desc) {
        this.desc = desc;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getCode() {
        return this.name().toLowerCase();
    }

    public boolean compareCode(String code) {
        return Objects.equals(code, this.getCode());
    }

    public static OrderStatus4ConsumerEnum getStatus(OrdersDto ordersDto, AmbPostsaleOrdersDto postOrdersDto, SupplierOrderDto supplierOrderDto, AmbSubOrdersDto ambSubOrdersDto) {
        if (OrderStatusEnum.StatusCreate.compareCode(ordersDto.getStatus())) {
            return CREATE;
        }
        if (ConsumerPayEnum.ConsumerPayStatusWaitPay.compareCode(ordersDto.getConsumerPayStatus())) {
            return WAIT_PAY;
        }
        if (OrderStatusEnum.StatusConsumeSuccess.compareCode(ordersDto.getStatus())) {
            OrderStatus4ConsumerEnum auditStatus = OrderStatus4ConsumerEnum.getAuditStatus(ordersDto);
            if (Objects.nonNull((Object)auditStatus)) {
                return auditStatus;
            }
            OrderStatus4ConsumerEnum shipStatus = OrderStatus4ConsumerEnum.getShipStatusBySupplierOrderDto(supplierOrderDto);
            if (Objects.nonNull((Object)shipStatus)) {
                return shipStatus;
            }
        }
        if (OrderStatusEnum.StatusAfterSend.compareCode(ordersDto.getStatus())) {
            if (OrderStatus4ConsumerEnum.isWaitShip(ambSubOrdersDto)) {
                return WAIT_SHIP;
            }
            OrderStatus4ConsumerEnum postStatus = OrderStatus4ConsumerEnum.getPostStatus(postOrdersDto);
            if (Objects.nonNull((Object)postStatus)) {
                return postStatus;
            }
            return OrderStatus4ConsumerEnum.getOrderStatus4ConsumerEnum(ambSubOrdersDto);
        }
        if (OrderStatusEnum.StatusSuccess.compareCode(ordersDto.getStatus())) {
            return SUCCESS;
        }
        if (OrderStatusEnum.StatusFAil.compareCode(ordersDto.getStatus())) {
            return FAIL;
        }
        return UNKNOWN;
    }

    private static OrderStatus4ConsumerEnum getOrderStatus4ConsumerEnum(AmbSubOrdersDto ambSubOrdersDto) {
        if (AmbSubOrderStatusEnum.Received.compareCode(ambSubOrdersDto.getShipStatus())) {
            return SUCCESS;
        }
        return AFTER_SEND;
    }

    @Nullable
    private static OrderStatus4ConsumerEnum getShipStatusBySupplierOrderDto(SupplierOrderDto supplierOrderDto) {
        if (Objects.nonNull(supplierOrderDto)) {
            if (SupplierOrderStatus.StatusCreate.compareCode(supplierOrderDto.getStatus())) {
                return DEALING;
            }
            if (SupplierOrderStatus.StatusSend.compareCode(supplierOrderDto.getStatus())) {
                return DEALING;
            }
            if (SupplierOrderStatus.StatusToDeliver.compareCode(supplierOrderDto.getStatus())) {
                return WAIT_SHIP;
            }
            if (SupplierOrderStatus.StatusSuccess.compareCode(supplierOrderDto.getStatus())) {
                return AFTER_SEND;
            }
        }
        return null;
    }

    @Nullable
    private static OrderStatus4ConsumerEnum getAuditStatus(OrdersDto ordersDto) {
        if (OrderAuditStatusEnum.wait.compareCode(ordersDto.getAuditStatus())) {
            return WAIT_AUDIT;
        }
        if (OrderAuditStatusEnum.reject.compareCode(ordersDto.getAuditStatus())) {
            return AUDIT_FAIL;
        }
        return null;
    }

    @Nullable
    private static OrderStatus4ConsumerEnum getPostStatus(AmbPostsaleOrdersDto postOrdersDto) {
        if (Objects.nonNull(postOrdersDto)) {
            String postsaleStatus = postOrdersDto.getPostsaleStatus();
            if (AmbPostSalesStatusEnum.POSTSALE_STATUS_WAIT.compareCode(postsaleStatus)) {
                return WAIT_POST;
            }
            if (AmbPostSalesStatusEnum.POSTSALE_STATUS_REFUNDING.compareCode(postsaleStatus)) {
                return REJECT_REFUND;
            }
            if (AmbPostSalesStatusEnum.POSTSALE_STATUS_AGREE.compareCode(postsaleStatus)) {
                return AGREE_REFUND;
            }
            if (AmbPostSalesStatusEnum.POSTSALE_STATUS_REFUNDING.compareCode(postsaleStatus)) {
                return REFUNDING;
            }
        }
        return null;
    }

    private static boolean isWaitShip(AmbSubOrdersDto ambSubOrdersDto) {
        if (Objects.nonNull(ambSubOrdersDto)) {
            if (AmbSubOrderStatusEnum.WaitShip.compareCode(ambSubOrdersDto.getShipStatus())) {
                return true;
            }
            if (AmbSubOrderStatusEnum.Create.compareCode(ambSubOrdersDto.getShipStatus())) {
                return true;
            }
            if (AmbSubOrderStatusEnum.Canceled.compareCode(ambSubOrdersDto.getShipStatus())) {
                return true;
            }
        }
        return false;
    }

    public static OrderStatus4ConsumerEnum ofValue(String code) {
        for (OrderStatus4ConsumerEnum orderEnum : OrderStatus4ConsumerEnum.values()) {
            if (!Objects.equals(orderEnum.getCode(), code)) continue;
            return orderEnum;
        }
        throw new UnsupportedOperationException("\u6d93\u5d86\u656e\u93b8\u4f7a\u6b91\u7eeb\u8bf2\u7037");
    }
}

