package cn.com.duiba.order.center.api.constant;

import java.util.Objects;

/**
 * Created by dugq on 2018-12-28.
 */
public enum ConsumerPayEnum {
    ConsumerPayStatusNone("none","无需支付"),
    ConsumerPayStatusWaitPay ("wait_pay","待支付"),
    ConsumerPayStatusPaySuccess ("pay_success","支付成功"),
    ConsumerPayStatusPayBack ("pay_back","退款"),
    ConsumerPayStatusCanceled ("canceled","取消"),
    ConsumerPayStatusSuccess ("success","支付成功"),
    ;
    private String code;
    private String desc;

    ConsumerPayEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc(){
        return desc;
    }

    public boolean compareCode(String code){
        return Objects.equals(code,getCode());
    }

    public static ConsumerPayEnum ofValue(String code) {
        for (ConsumerPayEnum orderAuditStatus : values()) {
            if (Objects.equals(orderAuditStatus.getCode(), code)) {
                return orderAuditStatus;
            }
        }
        throw new UnsupportedOperationException("不支持的类型");
    }
}
