package cn.com.duiba.order.center.api.constant;

import java.util.Objects;

/**
 * Created by dugq on 2018/12/5 0005.
 */
public enum  OrderAuditStatusEnum {
    wait("wait","待审核"),
    pass("pass","通过"),
    reject("reject","不通过"),
    none(null,"无需审核"),
    ;
    private String code;
    private String desc;

    OrderAuditStatusEnum(String value, String desc) {
        this.code = value;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static OrderAuditStatusEnum ofValue(String value){
        for (OrderAuditStatusEnum orderAuditStatus : values()){
            if(Objects.equals(orderAuditStatus.getCode(),value)){
                return orderAuditStatus;
            }
        }
        throw new UnsupportedOperationException("不支持的类型");
    }

    public boolean compareCode(String code){
        return Objects.equals(code, getCode());
    }
}
