package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteAmbOrderScanService <br/>
 * 定时扫描加速表订单并处理业务逻辑 <br/>
 * Date: 2017年2月6日 上午10:09:10 <br/>
 * 
 * @author sunyan
 */
@AdvancedFeignClient
public interface RemoteAmbOrderScanService {

    /**
     * 支付超时处理
     *
     * @param fastId
     * @return DubboResult
     */
    public DubboResult<OrdersDto> payTimeout(Long fastId);

    /**
     * 等待收货超时
     *
     * @param fastId
     * @return DubboResult
     */
    public DubboResult<OrdersDto> waitReceiveTimeout(Long fastId);

    /**
     * 收货7天后，不走售后 订单结束
     *
     * @param fastId
     * @return DubboResult
     */
    public DubboResult<OrdersDto> receivedTimeout(Long fastId);

    /**
     * 用户审请售后之后，7天后，没人处理。
     *
     * @param fastId
     * @return DubboResult
     */
    public DubboResult<OrdersDto> postsaleRejectTimeout(Long fastId);

    /**
     * 售后同意之后，等待用户寄，14天超时。
     * 
     * @param fastId
     * @return DubboResult
     */
    public DubboResult<OrdersDto> postsaleAgreeTimeout(Long fastId);
    
    /**
     * 60天超时定单处理
     * 
     * @param fastId
     * @return DubboResult
     */
    public DubboResult<OrdersDto> maxTimeTimeout(Long fastId);
}
