package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.constant.SubPaychannelType;
import cn.com.duiba.order.center.api.dto.AmbPaychannelOrdersDto;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.Date;
import java.util.List;

/**
 * 加钱购支付通道接口
 * Created by yansen on 16/9/26.
 */
@AdvancedFeignClient
public interface RemoteAmbPaychannelOrdersService {
    /**
     * 支付渠道表更新退款状态
     * @param orderNum 主订单号
     * @param status 退款状态
     * @return 是否更新成功
     */
    boolean updateRefundStatusByOrderNum(String orderNum, String status);
    /**
     * @param id
     * @return
     */
    public DubboResult<AmbPaychannelOrdersDto> findById(Long id);

    /**
     * @param id
     * @param money
     * @return
     */
    public DubboResult<Integer> updatePayBackMoneyByIdAndStatusSuccess(Long id, Long money);


    /**
     * @param id
     * @param tradeNum
     * @return
     */
    public DubboResult<Integer> updatePayChannel4SuccessByIdAndWaitPay(Long id, String tradeNum);

    /**
     * @param id
     * @param tradeNum
     * @return
     */
    public DubboResult<Integer> updatePayChannelTradeNumByIdAndWaitPay(Long id, String tradeNum);

    /**
     *
     * @param id
     * @param paychannelType
     * @param subPaychannelType
     * @return
     */
    public DubboResult<Integer> updatePayChannel4PaychannelTypeById(Long id, String paychannelType, SubPaychannelType subPaychannelType);

    /**
     * @param order
     * @param type
     * @return
     */
    public DubboResult<Integer> createAmbPayChannelOrder(OrdersDto order, String type);

    /**
     * 海底捞定制
     *
     * @param order
     * @param type
     * @param subPaychannelType
     * @return
     */
    @RequestMapping("/createAmbPayChannelOrderByHaidilao")
    public DubboResult<Integer> createAmbPayChannelOrder(OrdersDto order, String type, SubPaychannelType subPaychannelType);

    /**
     *
     */
    List<AmbPaychannelOrdersDto> findByParam(List<Long> developerIds, String status, Date endDate, Integer max);

    int updateSubPaychannelTypeById(Long id, SubPaychannelType subPaychannelType);

    /**
     * 根据主订单ID集合批量获取
     * @param ordersIds
     * @return
     */
    List<AmbPaychannelOrdersDto> findByOrdersIds(List<Long> ordersIds);

    /**
     * 根据交易单号查询
     * @param tradeNum
     * @return
     */
    AmbPaychannelOrdersDto findByTradeNum(String tradeNum);
}
