/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.api.dto;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

public class SupplierOrderDto
implements Serializable {
    public static final String PREFIX_ORDER = "duiba";
    public static final String StatusCreate = "create";
    public static final String StatusSend = "send";
    public static final String StatusSuccess = "success";
    public static final String StatusFail = "fail";
    public static final String StatusToDeliver = "to_deliver";
    public static final int StatusIntCreate = 0;
    public static final int StatusIntSend = 1;
    public static final int StatusIntSuccess = 2;
    public static final int StatusIntFail = 3;
    public static final int StatusIntToDeliver = 4;
    private static final long serialVersionUID = 1761818458939631342L;
    private Long id;
    private Long orderId;
    private Long supplierProductId;
    private String status;
    private Integer statusInt;
    private String errorMessage;
    private String supplierInfo;
    private String supplierBizId;
    private String bizParams;
    private String bizData;
    private Date sendTime;
    private String duibaOrderNum;
    private Date gmtCreate;
    private Date gmtModified;

    public SupplierOrderDto() {
    }

    public SupplierOrderDto(Long id) {
        this.id = id;
        this.gmtModified = new Date();
    }

    public SupplierOrderDto(boolean init4insert) {
        if (init4insert) {
            this.status = StatusCreate;
            this.statusInt = 0;
            this.gmtModified = this.gmtCreate = new Date();
        }
    }

    public static Integer statusToInt(String status) {
        if (StatusCreate.equals(status)) {
            return 0;
        }
        if (StatusSend.equals(status)) {
            return 1;
        }
        if (StatusSuccess.equals(status)) {
            return 2;
        }
        if (StatusFail.equals(status)) {
            return 3;
        }
        if (StatusToDeliver.equals(status)) {
            return 4;
        }
        return -1;
    }

    public static synchronized String generate() {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        long step = 10000L;
        int timesInt = new Random().nextInt(100);
        Long atomic = new Long((long)timesInt * step);
        String f = format.format(date);
        Long value = atomic = Long.valueOf(atomic + 1L);
        String v = value.toString();
        while (v.length() < 8) {
            v = "0" + v;
        }
        return PREFIX_ORDER + f + v;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public Long getSupplierProductId() {
        return this.supplierProductId;
    }

    public void setSupplierProductId(Long supplierProductId) {
        this.supplierProductId = supplierProductId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
        this.statusInt = SupplierOrderDto.statusToInt(status);
    }

    public Integer getStatusInt() {
        return this.statusInt;
    }

    public void setStatusInt(Integer statusInt) {
        this.statusInt = statusInt;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getSupplierInfo() {
        return this.supplierInfo;
    }

    public void setSupplierInfo(String supplierInfo) {
        this.supplierInfo = supplierInfo;
    }

    public String getSupplierBizId() {
        return this.supplierBizId;
    }

    public void setSupplierBizId(String supplierBizId) {
        this.supplierBizId = supplierBizId;
    }

    public String getBizParams() {
        return this.bizParams;
    }

    public void setBizParams(String bizParams) {
        this.bizParams = bizParams;
    }

    public String getBizData() {
        return this.bizData;
    }

    public void setBizData(String bizData) {
        this.bizData = bizData;
    }

    public Date getSendTime() {
        return this.sendTime;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public String getDuibaOrderNum() {
        return this.duibaOrderNum;
    }

    public void setDuibaOrderNum(String duibaOrderNum) {
        this.duibaOrderNum = duibaOrderNum;
    }

    public Date getGmtCreate() {
        return this.gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return this.gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}

