/**
 * Project Name:trade-center-api
 * File Name:RemoteAmbPostsaleOrdersService.java
 * Package Name:cn.com.duiba.order.center.api.remoteservice
 * Date:2017年2月7日下午7:21:41
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.AmbPostsaleOrdersDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * ClassName:RemoteAmbPostsaleOrdersService <br/>
 * Date:     2017年2月7日 下午7:21:41 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteAmbPostsaleOrdersService {

    /**
     * @param id
     * @return DubboResult
     */
    DubboResult<AmbPostsaleOrdersDto> findById(Long id);

    DubboResult<List<AmbPostsaleOrdersDto>> findAllByIds(List<Long> ids);

    DubboResult<List<AmbPostsaleOrdersDto>> findAllByOrderId(Long orderId);

    List<AmbPostsaleOrdersDto> findAllByOrderIds(List<Long> orderIds);

    AmbPostsaleOrdersDto findNewestByOrderId(Long orderId);
}

