package cn.com.duiba.order.center.api.dto;

import cn.com.duiba.order.center.api.constant.OrderPromoTypeEnum;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 *
 * @author JunAngLiu
 * @Title: OrderItemDto
 * @Description: 针对 多商品 订单  子订单 dto
 * @date 2018/6/2913:59
 */
public class OrderItemDto implements Serializable {

    private static final long serialVersionUID = 7648999033042607584L;
    private Long credits;//子订单 消耗 总节分
    private Long ordersItemId;

    private Long orderId;

    private Long consumerId;
    /**
     * 涉及到 价格 ，以 分 为单位
     * */
    private Long price;//单价，以 分 为单位

    private Long itemId;//商品id

    private Long skuId;//兑吧skuid

    private Long appSkuId; //开发者skuId
    private Integer quantity;//数量

    private Long appItemId;//开发者商品id

    private String itemBrief;//商品标题

    /**
     * 是否参与优惠， true 为参与
     * */
    private Boolean promotion ;
    private Long totalPrice;//子订单 应付总价，以 分 为单位
    private Long promotionPrice;//子订单优惠价格，以 分 为单位
    private Long actualPrice;//子订单 实付总价，以 分 为单位

    private OrderPromoTypeEnum orderPromoTypeEnum; //优惠类型枚举
    private Long promoActivityId; //营销活动ID
    private Long promotionCredits;//子订单优惠积分
    private String extraInfo;//子订单扩展信息

    /**
     * 优惠券商品, 具体的优惠券ID
     */
    private Long couponId;

    private Date gmtCreate;

    private Date gmtModified;

    public Long getOrdersItemId() {
        return ordersItemId;
    }

    public void setOrdersItemId(Long ordersItemId) {
        this.ordersItemId = ordersItemId;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }


    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getAppSkuId() {
        return appSkuId;
    }

    public void setAppSkuId(Long appSkuId) {
        this.appSkuId = appSkuId;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public String getItemBrief() {
        return itemBrief;
    }

    public void setItemBrief(String itemBrief) {
        this.itemBrief = itemBrief;
    }

    public Boolean getPromotion() {
        return promotion;
    }

    public void setPromotion(Boolean promotion) {
        this.promotion = promotion;
    }

    public OrderPromoTypeEnum getOrderPromoTypeEnum() {
        return orderPromoTypeEnum;
    }

    public void setOrderPromoTypeEnum(OrderPromoTypeEnum orderPromoTypeEnum) {
        this.orderPromoTypeEnum = orderPromoTypeEnum;
    }

    public Long getPromoActivityId() {
        return promoActivityId;
    }

    public void setPromoActivityId(Long promoActivityId) {
        this.promoActivityId = promoActivityId;
    }

    public Long getPrice() {
        return price;
    }

    public void setPrice(Long price) {
        this.price = price;
    }

    public Long getTotalPrice() {
        return totalPrice;
    }

    public void setTotalPrice(Long totalPrice) {
        this.totalPrice = totalPrice;
    }

    public Long getPromotionPrice() {
        return promotionPrice;
    }

    public void setPromotionPrice(Long promotionPrice) {
        this.promotionPrice = promotionPrice;
    }

    public Long getActualPrice() {
        return actualPrice;
    }

    public void setActualPrice(Long actualPrice) {
        this.actualPrice = actualPrice;
    }

    public Long getPromotionCredits() {
        return promotionCredits;
    }

    public void setPromotionCredits(Long promotionCredits) {
        this.promotionCredits = promotionCredits;
    }

    public String getExtraInfo() {
        return extraInfo;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public Long getCouponId() {
        return couponId;
    }

    public void setCouponId(Long couponId) {
        this.couponId = couponId;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrderItemDto that = (OrderItemDto) o;
        return orderPromoTypeEnum == that.orderPromoTypeEnum &&
                Objects.equals(promoActivityId, that.promoActivityId);
    }

    @Override
    public int hashCode() {

        return Objects.hash(orderPromoTypeEnum, promoActivityId);
    }
}
