package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.AmbPostsaleOrderFasterDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 17/3/29.
 */
@AdvancedFeignClient
public interface RemoteAmbPostsaleOrderFasterService {
    /**
     * 必填参数 appId
     * 可选参数orderType,orderNumber,startTime,endTime,partnerUserId,itemTitle,postsaleStatus
     *
     * @param queryMap
     * @return
     */
    @Deprecated
    public Long findPageCountForDlp(Map<String, Object> queryMap);

    DubboResult<Long> findPageCountForDlpNew(Map<String, Object> queryMap);

    Long findPageCountForDuiBaNew(Map<String, Object> queryMap);

    DubboResult<List<AmbPostsaleOrderFasterDto>> findPage(Map<String, Object> queryMap);

    List<AmbPostsaleOrderFasterDto> findDuiBaPage(Map<String, Object> queryMap);

    DubboResult<AmbPostsaleOrderFasterDto> findByOrderId(Long orderId);

    List<AmbPostsaleOrderFasterDto> findByAppIdAndOrderIdsAndStatus(Long appId,
                                                                    List<Long> orderIds,
                                                                    String postsaleStatus);

     List<AmbPostsaleOrderFasterDto> findPostsalIngByCid(Long cid, Integer offset);

    /**
     * 查询主订单售后状态,true-售后中，false-售后完成
     * @param orderId
     * @return
     */
     Boolean findOrderPostSaleStatus(Long orderId);
}
