/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.order.center.api.tool;

import cn.com.duiba.order.center.api.constant.OrderTypeEnum;
import cn.com.duiba.order.center.api.constant.StatusIntEnum;
import cn.com.duiba.order.center.api.dto.AmbSubOrdersDto;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class OrderUtils {
    private OrderUtils() {
    }

    public static Boolean isNewOrder(OrdersDto order) {
        return Objects.isNull(order.getAppItemId()) && Objects.isNull(order.getItemId());
    }

    public static StatusIntEnum getStatus(OrdersDto dto, AmbSubOrdersDto subDto) {
        if ("ConsumerPay-started".equalsIgnoreCase(dto.getFlowworkStage())) {
            return StatusIntEnum.WAIT_PAY;
        }
        if ("Audit-Started".equalsIgnoreCase(dto.getFlowworkStage())) {
            return StatusIntEnum.WAIT_AUDIT;
        }
        if (OrderTypeEnum.OBJECT.getType().equals(dto.getType()) && "SupplierExchange-Started".equalsIgnoreCase(dto.getFlowworkStage())) {
            return StatusIntEnum.WAIT_SEND;
        }
        if ("success".equalsIgnoreCase(dto.getStatus())) {
            return StatusIntEnum.SUCCESS;
        }
        Integer statusInt = dto.getStatusInt();
        if (statusInt != null && statusInt >= StatusIntEnum.WAIT_PAY.getCode()) {
            if ("Fail-complete".equalsIgnoreCase(dto.getFlowworkStage())) {
                return StatusIntEnum.ofValue(statusInt);
            }
            if ("AfterSend-Started".equalsIgnoreCase(dto.getFlowworkStage())) {
                return StatusIntEnum.ofValue(statusInt);
            }
        } else {
            if ("AfterSend-Started".equalsIgnoreCase(dto.getFlowworkStage())) {
                if (Objects.nonNull(subDto) && Objects.equals("received", subDto.getShipStatus())) {
                    return StatusIntEnum.RECEIVE;
                }
                return StatusIntEnum.WAIT_RECEIVE;
            }
            if ("fail".equalsIgnoreCase(dto.getStatus()) || "Create-tofail".equalsIgnoreCase(dto.getFlowworkStage())) {
                return StatusIntEnum.FAIL;
            }
        }
        return StatusIntEnum.PROCESSING;
    }

    public static boolean isMallOrder(OrdersDto order) {
        return "mall".equals(order.getChargeMode()) || "api".equals(order.getChargeMode());
    }

    public static boolean isPurchaseOrder(OrdersDto ordersDto) {
        Long supplierId;
        JSONObject extra;
        boolean ret = false;
        if (ordersDto.getItemId() != null && StringUtils.isNotBlank((String)ordersDto.getExtraInfo()) && (extra = JSONObject.parseObject((String)ordersDto.getExtraInfo())) != null && (supplierId = extra.getLong("supplierId")) != null) {
            ret = true;
        }
        return ret;
    }
}

