package cn.com.duiba.order.center.api.constant;

import java.util.Objects;

public enum PostsaleStatusEnum {
    POSTSALE_STATUS_WAIT("wait","待售后"),
    POSTSALE_STATUS_AGREE("agree","商家同意"),
    POSTSALE_STATUS_MERCHANTS_RECEIVED("merchantsReceived","商家验货"),
    POSTSALE_STATUS_ROLLBACK_EXCEPTION("rollbackException","退积分或退款时异常"),
    POSTSALE_STATUS_REFUNDING("refunding","退款中"),
    POSTSALE_STATUS_REJECT("reject","拒绝售后"),
    POSTSALE_STATUS_CANCELED("canceled","取消售后"),
    POSTSALE_STATUS_SUCCESS("success","售后成功"),

    ;

    private String code;
    private String desc;

    PostsaleStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    public static PostsaleStatusEnum ofValue(String code){
        for (PostsaleStatusEnum type : values()){
            if(Objects.equals(code,type.getCode())){
                return type;
            }
        }
        throw new UnsupportedOperationException("不支持的类型");
    }
    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
