package cn.com.duiba.order.center.api.tool;

import java.util.Objects;

import cn.com.duiba.order.center.api.constant.OrderItemStatusEnum;
import cn.com.duiba.order.center.api.constant.OrderTypeEnum;
import cn.com.duiba.order.center.api.constant.StatusIntEnum;
import cn.com.duiba.order.center.api.dto.AmbSubOrdersDto;
import cn.com.duiba.order.center.api.dto.OrderItemDto;
import cn.com.duiba.order.center.api.dto.OrdersDto;

/**
 * Created by zhangshun on 2018/12/24,09:33:51.
 */
public class OrderUtils {

    private OrderUtils() {

    }

    /**
     * 是否新订单
     *
     * @param order
     * @return
     */
    public static Boolean isNewOrder(OrdersDto order) {
        return Objects.isNull(order.getAppItemId()) && Objects.isNull(order.getItemId());
    }


    public static StatusIntEnum getStatus(OrdersDto dto, AmbSubOrdersDto subDto) {
        if ("ConsumerPay-started".equalsIgnoreCase(dto.getFlowworkStage())) {
            return StatusIntEnum.WAIT_PAY;
        }
        // 买家付款完成, 下个状态为: 等待商家审核
        if ("Audit-Started".equalsIgnoreCase(dto.getFlowworkStage())) {
            return StatusIntEnum.WAIT_AUDIT;
        }
        //待发货
        if (OrderTypeEnum.OBJECT.getType().equals(dto.getType()) && "SupplierExchange-Started".equalsIgnoreCase(dto.getFlowworkStage())) {
            return StatusIntEnum.WAIT_SEND;
        }

        // 成功
        if (OrdersDto.StatusSuccess.equalsIgnoreCase(dto.getStatus())) {
            return StatusIntEnum.SUCCESS;
        }
        Integer statusInt = dto.getStatusInt();
        if (statusInt != null && statusInt >= StatusIntEnum.WAIT_PAY.getCode()) {
            //新逻辑 展示 已取消，已失效，异常
            if ("Fail-complete".equalsIgnoreCase(dto.getFlowworkStage())) {
                return StatusIntEnum.ofValue(statusInt);
            }
            // 商家已发货, 下个状态为: 确认收货
            if ("AfterSend-Started".equalsIgnoreCase(dto.getFlowworkStage())) {
                // 已收货
//                if (Objects.nonNull(orderItemDto) &&
//                        Objects.equals(OrderItemStatusEnum.RECEIVE.getCode(), orderItemDto.getStatus())) {
//                    return StatusIntEnum.RECEIVE;
//                }
                // 已发货
//                return StatusIntEnum.WAIT_RECEIVE;
                return StatusIntEnum.ofValue(statusInt);
            }
        } else {
            // 商家已发货, 下个状态为: 确认收货
            if ("AfterSend-Started".equalsIgnoreCase(dto.getFlowworkStage())) {
                // 已收货
                if (Objects.nonNull(subDto) &&
                        Objects.equals(AmbSubOrdersDto.SubOrdersShipStatusReceived, subDto.getShipStatus())) {
                    return StatusIntEnum.RECEIVE;
                }
                // 已发货
                return StatusIntEnum.WAIT_RECEIVE;
            }
            // 失败
            if (OrdersDto.StatusFAil.equalsIgnoreCase(dto.getStatus()) ||
                    "Create-tofail".equalsIgnoreCase(dto.getFlowworkStage())) {
                //老的都叫失败
                return StatusIntEnum.FAIL;
            }
        }
        return StatusIntEnum.PROCESSING;
    }

}
