package cn.com.duiba.order.center.api.constant;

import java.util.Objects;

/**
 * Created by dugq on 2018-12-28.
 */
public enum AmbSubOrderStatusEnum {
    Create("create","处理中"),
    WaitShip("wait_ship","待发货"),
    Shipped("shipped","已发货"),
    Canceled("canceled","已取消"),
    Received("received","已收货"),
    ;
    private String code;
    private String desc;

    AmbSubOrderStatusEnum(String code,String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static AmbSubOrderStatusEnum ofValue(String code) {
        for (AmbSubOrderStatusEnum orderAuditStatus : values()) {
            if (Objects.equals(orderAuditStatus.getCode(), code)) {
                return orderAuditStatus;
            }
        }
        throw new UnsupportedOperationException("不支持的类型");
    }

    public boolean compareCode(String code) {
        return Objects.equals(code, getCode());
    }

}
