package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.AmbOrderFastDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

/**
 * 加钱购加速订单接口
 * Created by yansen on 16/9/26.
 */
@AdvancedFeignClient
public interface RemoteAmbOrderFastService {

    /**
     *
     * @param orderId
     * @param consumerId
     * @param orderGmtCreate
     * @return
     */
    public DubboResult<AmbOrderFastDto> createOrderFastWaitPay(Long orderId, Long consumerId, Date orderGmtCreate);

    /**
     *
     * @param orderId
     * @return
     */
    public DubboResult<Integer> deleteByOrderId(Long orderId);

    /**
     *
     * @param orderId
     * @param consumerId
     * @return
     */
    DubboResult<AmbOrderFastDto> createOrderFastWaitReceive(Long orderId, Long consumerId);

    /**
     * 自定义扫描时间
     * @param orderId
     * @param consumerId
     * @return
     */
    DubboResult<AmbOrderFastDto> createOrderFastWaitPayForDay(Long orderId, Long consumerId, Integer day);

    /**
     * 扫描纯积分订单
     * @param orderFastType
     * @return
     */
    DubboResult<List<AmbOrderFastDto>> findExpiredByTypeAndCredits(String orderFastType);

    /**
     * 按orderFastType查询当前过期加速订单
     * @param orderFastType
     * @return
     */
    DubboResult<List<AmbOrderFastDto>> findExpiredByType(String orderFastType);

    /**
     *
     * @param orderId
     * @param status
     * @return
     */
    DubboResult<AmbOrderFastDto> findByOrderIdAndType(Long orderId, String status);

    /**
     *
     * @param orderId
     * @param orderFastType
     * @return
     */
    public DubboResult<Integer> deleteByTypeAndOrderId(Long orderId, String orderFastType);

}
