package cn.com.duiba.order.center.api.constant;

import cn.com.duiba.order.center.api.dto.AmbPostsaleOrdersDto;
import cn.com.duiba.order.center.api.dto.AmbSubOrdersDto;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.dto.SupplierOrderDto;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

/**
 * Created by dugq on 2018-12-28.
 */
public enum OrderStatus4ConsumerEnum {
    CREATE("创建中"), //待支付之前
    WAIT_PAY("待支付"),
    WAIT_AUDIT("待审核"),
    AUDIT_FAIL("审核失败"),
    DEALING("处理中"), //非实物类商品 供应商或者商家在处理，用户支付成功，已发货之前
    WAIT_SHIP("待发货"), //实物
    AFTER_SEND("已发货"), //实物
    RECEIVED("已收货"), //实物
    WAIT_POST("售后待处理"), //卖家同意售后之前
    REJECT_REFUND("拒绝售后"),
    AGREE_REFUND("同意售后"),
    REFUNDING("退款中"), //卖家退款中
    SUCCESS("交易成功"),
    FAIL("交易关闭"),
    UNKNOWN("处理中")
    ;
    private String desc;

    OrderStatus4ConsumerEnum(String desc) {
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return name().toLowerCase();
    }

    public boolean compareCode(String code){
        return Objects.equals(code,getCode());
    }

    public static OrderStatus4ConsumerEnum  getStatus(OrdersDto ordersDto, AmbPostsaleOrdersDto postOrdersDto, SupplierOrderDto supplierOrderDto, AmbSubOrdersDto ambSubOrdersDto){
        if(OrderStatusEnum.StatusCreate.compareCode(ordersDto.getStatus())){
            return CREATE;
        }
        if(ConsumerPayEnum.ConsumerPayStatusWaitPay.compareCode(ordersDto.getConsumerPayStatus())){
            return WAIT_PAY;
        }
        if(OrderStatusEnum.StatusConsumeSuccess.compareCode(ordersDto.getStatus())){
            OrderStatus4ConsumerEnum auditStatus = getAuditStatus(ordersDto);
            if (Objects.nonNull(auditStatus)){
                return auditStatus;
            }
            OrderStatus4ConsumerEnum shipStatus = getShipStatusBySupplierOrderDto(supplierOrderDto);
            if (Objects.nonNull(shipStatus)){
                return shipStatus;
            }
        }
        if(OrderStatusEnum.StatusAfterSend.compareCode(ordersDto.getStatus())){
            if (isWaitShip(ambSubOrdersDto)) {
                return WAIT_SHIP;
            }
            OrderStatus4ConsumerEnum postStatus = getPostStatus(postOrdersDto);
            if (Objects.nonNull(postStatus)){
                return postStatus;
            }
            return getOrderStatus4ConsumerEnum(ambSubOrdersDto);
        }
        if (OrderStatusEnum.StatusSuccess.compareCode(ordersDto.getStatus())){
            return SUCCESS;
        }
        if(OrderStatusEnum.StatusFAil.compareCode(ordersDto.getStatus())){
            return FAIL;
        }
        return UNKNOWN;
    }

    private static OrderStatus4ConsumerEnum getOrderStatus4ConsumerEnum(AmbSubOrdersDto ambSubOrdersDto) {
        if(AmbSubOrderStatusEnum.Received.compareCode(ambSubOrdersDto.getShipStatus())){
            return SUCCESS;
        }
        return AFTER_SEND;
    }

    @Nullable
    private static OrderStatus4ConsumerEnum getShipStatusBySupplierOrderDto(SupplierOrderDto supplierOrderDto) {
        if(Objects.nonNull(supplierOrderDto)){
            if(SupplierOrderStatus.StatusCreate.compareCode(supplierOrderDto.getStatus())){
                return DEALING;
            }
            if(SupplierOrderStatus.StatusSend.compareCode(supplierOrderDto.getStatus())){
                return DEALING;
            }
            if(SupplierOrderStatus.StatusToDeliver.compareCode(supplierOrderDto.getStatus())){
                return WAIT_SHIP;
            }
            if(SupplierOrderStatus.StatusSuccess.compareCode(supplierOrderDto.getStatus())){
                return AFTER_SEND;
            }
        }
        return null;
    }

    @Nullable
    private static OrderStatus4ConsumerEnum getAuditStatus(OrdersDto ordersDto) {
        if(OrderAuditStatusEnum.wait.compareCode(ordersDto.getAuditStatus())){
            return WAIT_AUDIT;
        }
        if(OrderAuditStatusEnum.reject.compareCode(ordersDto.getAuditStatus())){
            return AUDIT_FAIL;
        }
        return null;
    }

    @Nullable
    private static OrderStatus4ConsumerEnum getPostStatus(AmbPostsaleOrdersDto postOrdersDto) {
        if(Objects.nonNull(postOrdersDto)){
            String postsaleStatus = postOrdersDto.getPostsaleStatus();
            if(AmbPostSalesStatusEnum.POSTSALE_STATUS_WAIT.compareCode(postsaleStatus)){
                return WAIT_POST;
            }
            if(AmbPostSalesStatusEnum.POSTSALE_STATUS_REFUNDING.compareCode(postsaleStatus)){
                return REJECT_REFUND;
            }
            if(AmbPostSalesStatusEnum.POSTSALE_STATUS_AGREE.compareCode(postsaleStatus)){
                return AGREE_REFUND;
            }
            if(AmbPostSalesStatusEnum.POSTSALE_STATUS_REFUNDING.compareCode(postsaleStatus)){
                return REFUNDING;
            }
        }
        return null;
    }

    private static boolean isWaitShip(AmbSubOrdersDto ambSubOrdersDto) {
        if(Objects.nonNull(ambSubOrdersDto)){
            if(AmbSubOrderStatusEnum.WaitShip.compareCode(ambSubOrdersDto.getShipStatus())){
                return true;
            }
            if (AmbSubOrderStatusEnum.Create.compareCode(ambSubOrdersDto.getShipStatus())){
                return true;
            }
            if (AmbSubOrderStatusEnum.Canceled.compareCode(ambSubOrdersDto.getShipStatus())){
                return true;
            }
        }
        return false;
    }

    public static OrderStatus4ConsumerEnum ofValue(String code){
        for (OrderStatus4ConsumerEnum orderEnum:values()){
            if (Objects.equals(orderEnum.getCode(),code)){
                return orderEnum;
            }
        }
        throw new UnsupportedOperationException("不支持的类型");
    }
}
