package cn.com.duiba.order.center.api.constant;

import java.util.Objects;

/**
 * Created by dugq on 2018-12-28.
 */
public enum OrderStatusEnum {
    StatusCreate("create","创建中"),
    StatusSuccess("success","交易成功"),
    StatusFAil("fail","交易失败"),
    StatusConsumeSuccess("consume_success","支付成功"),
    StatusConsumeFail("consume_fail","支付失败"),
    StatusAfterSend("after_send","已发货"),
    ;
    private String code;
    private String desc;

    private OrderStatusEnum(String code ,String desc){
        this.code = code;
        this.desc = desc;
    }
    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public boolean compareCode(String code){
        return Objects.equals(code,getCode());
    }


}
