package cn.com.duiba.order.center.api.constant;


/**
 * 用于管理使用Redis的所有key前缀，避免业务key重复<br>
 * 用法：枚举_业务参数
 * <p/>
 * Created by xinning on 2018/8/23.
 */
public enum RedisKeyFactory {
    K001("商品兑换记录"),
    K002("海底捞订单同步时候做分布式锁用"),;


    /**
     * 交易中心:trade-center
     */
    private static final String SPACE = "TC";

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }

    private RedisKeyFactory(String description) {

    }

}
