package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.AmbAlipayPaybackDto;
import cn.com.duiba.order.center.api.dto.AmbOrderFastDto;
import cn.com.duiba.order.center.api.dto.PostsaleCreditsDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

@AdvancedFeignClient
public interface RemotePostsaleCreditsPaybackService {

    boolean updateSend2Success(Long postsaleOrderNum, String message);

    boolean updateSend2Fail(Long postsaleOrderNum, String message);

    boolean insert(PostsaleCreditsDto dto);

    boolean updateRefunding2Send(PostsaleCreditsDto dto);

    boolean updateRefunding2Fail(PostsaleCreditsDto dto);

    boolean updateRefunding2Exception(PostsaleCreditsDto dto);

    /**
     * 根据子订单id查询
     * @param orderItemId
     * @return
     */
    PostsaleCreditsDto findByOrderItemId(Long orderItemId);

    List<PostsaleCreditsDto> findByOrderId(Long orderId);

    List<PostsaleCreditsDto> findListByOrderIds(List<Long> orderIds);
}
