package cn.com.duiba.order.center.api.constant;

import java.util.Objects;

/**
 * Created by dugq on 2018-12-28.
 */
public enum AmbPostSalesStatusEnum {
    POSTSALE_STATUS_WAIT("wait","待售后"),
    POSTSALE_STATUS_REFUNDING("refunding","退款中"),
    POSTSALE_STATUS_REJECT("reject","售后拒绝"),
    POSTSALE_STATUS_CANCELED("canceled","售后取消"),
    POSTSALE_STATUS_AGREE("agree","待用户寄回"),
    POSTSALE_STATUS_SUCCESS("success","退款成功"),
    POSTSALE_STATUS_MERCHANTS_RECEIVED("merchants_received","商家验货"),
    POSTSALE_STATUS_ERROR("error","退款异常"),
    ;
    private String code;
    private String desc;

    AmbPostSalesStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static AmbPostSalesStatusEnum ofValue(String code) {
        for (AmbPostSalesStatusEnum orderAuditStatus : values()) {
            if (Objects.equals(orderAuditStatus.getCode(), code)) {
                return orderAuditStatus;
            }
        }
        throw new UnsupportedOperationException("不支持的类型");
    }

    public boolean compareCode(String code) {
        return Objects.equals(code, getCode());
    }
}
