package cn.com.duiba.order.center.api.constant;

import java.util.Objects;

/**
 * Created by dugq on 2018-12-28.
 */
public enum SupplierOrderStatus {
    StatusCreate (0,"create"," 创建订单"),
    StatusSend (1,"send","已经发送请求"),
    StatusSuccess (2,"success"," 处理成功"),
    StatusFail (3,"fail"," 处理失败"),
    StatusToDeliver (4,"to_deliver"," 实物兑换，待发货"),
    ;

    private Integer statusInt;
    private String code;
    private String desc;

    SupplierOrderStatus(Integer statusInt, String code, String desc) {
        this.statusInt = statusInt;
        this.code = code;
        this.desc = desc;
    }

    public static SupplierOrderStatus ofValue(String code){
        for (SupplierOrderStatus orderAuditStatus : values()){
            if(Objects.equals(orderAuditStatus.getCode(),code)){
                return orderAuditStatus;
            }
        }
        throw new UnsupportedOperationException("不支持的类型");
    }

    public boolean compareCode(String code){
        return Objects.equals(code, getCode());
    }


    public Integer getStatusInt() {
        return statusInt;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }}
