/**
 * Project Name:trade-center-api
 * File Name:RemoteAmbPostsaleOrdersService.java
 * Package Name:cn.com.duiba.order.center.api.remoteservice
 * Date:2017年2月7日下午7:21:41
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.AmbPostsaleOrdersDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * ClassName:RemoteAmbPostsaleOrdersService <br/>
 * Date:     2017年2月7日 下午7:21:41 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteAmbPostsaleOrdersService {

    /**
     * @param id
     * @return DubboResult
     */
    DubboResult<AmbPostsaleOrdersDto> findById(Long id);

    DubboResult<List<AmbPostsaleOrdersDto>> findAllByIds(List<Long> ids);

    DubboResult<List<AmbPostsaleOrdersDto>> findAllByOrderId(Long orderId);

    List<AmbPostsaleOrdersDto> findAllByOrderIds(List<Long> orderIds);

    List<AmbPostsaleOrdersDto> findAllByOrderIdsNew(List<Long> orderIds);

    AmbPostsaleOrdersDto findNewestByOrderId(Long orderId);

    Long findDealingCount(String status, String startDate, String endDate);

    /**
     * 查询子订单最新的售后记录
     * @param orderId
     * @param ordersItemId
     * @return
     */
    AmbPostsaleOrdersDto findByOrderItemId(Long orderId, Long ordersItemId);

    /**
     * key: 子订单ID;  value: 售后工单对象
     * 根据订单id查找子订单中每一条最新的售后记录，如果有
     * @param orderId
     * @return
     */
    Map<Long, AmbPostsaleOrdersDto> findLatestGroupByOrderId(Long orderId);
}

