package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.order.center.api.dto.ActivityOrdersDto;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.paramquery.ActivityOrdersPageQuery;
import cn.com.duiba.order.center.api.paramquery.OrdersAppSearchQuery;
import cn.com.duiba.order.center.api.paramquery.Page;
import cn.com.duiba.order.center.api.paramquery.ProjectxOrderPageQuery;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

/**
 * 主订单--开发者维度拆分表--基础接口
 * @author zhaodongxue
 *
 */
@AdvancedFeignClient
public interface RemoteMirrorOrderSimpleService {

	/**
	 *
	 * @param orderId
	 * @param appId
	 * @return
     */
	DubboResult<OrdersDto> findByOrderId(Long orderId, Long appId);

	/**
	 * 查询订单，无appId
	 * @param orderId
	 * @return
	 */
	OrdersDto findByOrderIdNoApp(Long orderId);

	/**
	 *
	 * @param ids
	 * @param appId
     * @return
     */
	DubboResult<List<OrdersDto>> findByOrderIds(List<Long> ids, Long appId);

	/**
	 * 查询订单，无appId
	 * @param ids
	 * @return
	 */
	List<OrdersDto> findByOrderIdsNoApp(List<Long> ids);

	/**
	 *
	 * @param orderNum
	 * @param appId
     * @return
     */
	DubboResult<OrdersDto> findByOrderNum(String orderNum, Long appId);

	/**
	 *
	 * @param orderNums
	 * @param appId
     * @return
     */
	DubboResult<List<OrdersDto>> findByOrderNums(List<String> orderNums, Long appId);

	List<OrdersDto> findByOrderNumsNotAppId(List<String> orderNums);


	/**
	 *
	 * @param ordersAppSearchQuery
	 * @return
     */
	@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="15000")
	Page<OrdersDto> findOrdersByGmtCreate(OrdersAppSearchQuery ordersAppSearchQuery);

	@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="15000")
	Page<OrdersDto> findProcessOrders(OrdersAppSearchQuery ordersAppSearchQuery);

	@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="15000")
	Page<OrdersDto> findOrderNotApp(OrdersAppSearchQuery ordersAppSearchQuery);

	@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="15000")
	Page<OrdersDto> findOrderByStraightGoods(OrdersAppSearchQuery ordersAppSearchQuery, List<String> orderNum);

	@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="15000")
	DubboResult<Long> countOrdersByGmtCreate(OrdersAppSearchQuery ordersAppSearchQuery);

    @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="60000")
	Page<ActivityOrdersDto> findActivityOrdersPageByDay(ActivityOrdersPageQuery activityOrdersPageQuery);

    @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="15000")
	DubboResult<Integer> findOrderCountByAppIdAndDate(Long appId, Date startDate, Date endDate);

	@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="15000")
	Page<OrdersDto> findOrderByApp(OrdersAppSearchQuery ordersAppSearchQuery);

	@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="15000")
	Page<ActivityOrdersDto> findActivityOrdersPageOnlyByES(ActivityOrdersPageQuery activityOrdersPageQuery);

	@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="15000")
	DubboResult<Long> countProjectxTimeoutOrder(ActivityOrdersPageQuery activityOrdersPageQuery);

	@FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="10000")
	Page<ActivityOrdersDto> findProjectxOrdersPageOnlyByES(ProjectxOrderPageQuery projectxOrderPageQuery) throws BizException;
}
