package cn.com.duiba.order.center.api.tool;

import cn.com.duiba.order.center.api.dto.OrderItemDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

/**
 * @Date 2022/3/1 3:26 下午
 * @Created by cmm
 */
public class OrderItemUtils {
    /**
     * 老版本子订单号从一亿开始递增目前在十二亿左右，新版本在原来的基础上加了四位表名
     * @param orderItemId
     * @return
     */
    public static boolean isNewOrderItem(Long orderItemId) {
        return orderItemId > 10000000000L;
    }

    /**
     * 获取子订单表
     * @param orderItemId
     * @return
     */
    public static String getSuffix(Long orderItemId) {
        boolean isNew = isNewOrderItem(orderItemId);
        if (!isNew) {
            throw new RuntimeException("老订单不支持");
        }
        long tbInt = orderItemId % 10000;
        String tb = tbInt + "";
        if (tbInt < 10) {
            tb = "000" + tbInt;
        } else if (tbInt < 100) {
            tb = "00" + tbInt;
        } else if (tbInt < 1000) {
            tb = "0" + tbInt;
        }
        return tb;
    }

    /**
     * 获取分销商子订单号，兼容老数据
     * @param bizParam
     * @return
     */
    public static Long getDistributorsOrderSort(String bizParam) {
        if (StringUtils.isBlank(bizParam)) {
            return null;
        }
        JSONObject orderItemExtraInfo = JSON.parseObject(bizParam);
        if (orderItemExtraInfo == null) {
            return null;
        }
        Long orderSort = orderItemExtraInfo.getLong(OrderItemDto.DISTRIBUTORS_SUB_ORDER_ID );
        if (orderSort == null) {
            Long oldOrderSort = orderItemExtraInfo.getJSONArray("distributorsSubOrderIds") != null ? orderItemExtraInfo.getJSONArray("distributorsSubOrderIds").getLong(0) : null;
            orderSort = orderSort == null ? oldOrderSort : orderSort;
        }
        return orderSort;
    }

    /**
     * 获取供应商子订单号，兼容老数据
     * @param bizParam
     * @return
     */
    public static Long getSupplierOrderSort(String bizParam) {
        if (StringUtils.isBlank(bizParam)) {
            return null;
        }
        JSONObject orderItemExtraInfo = JSON.parseObject(bizParam);
        if (orderItemExtraInfo == null) {
            return null;
        }
        Long orderSort = orderItemExtraInfo.getLong(OrderItemDto.SUPPLIER_SUB_ORDER_ID );
        if (orderSort == null) {
            Long oldOrderSort = orderItemExtraInfo.getJSONArray("supplierSubOrderIds") != null ? orderItemExtraInfo.getJSONArray("supplierSubOrderIds").getLong(0) : null;
            orderSort = orderSort == null ? oldOrderSort : orderSort;
        }
        return orderSort;
    }

    /**
     * 是否是购物车供应商子订单
     * @param orderItemDto
     * @return
     */
    public static boolean isPurchaseOrder(OrderItemDto orderItemDto) {
        //判断是不是供应商商品
        boolean ret = false;
        //如果是兑吧实物商品
        if(orderItemDto.getItemId() != null && StringUtils.isNotBlank(orderItemDto.getBizParam())){
            JSONObject extra = JSONObject.parseObject(orderItemDto.getBizParam());
            if(extra != null){
                Long supplierId = extra.getLong(OrderItemDto.SUPPLIER_ID);
                if(supplierId != null){
                    ret = true;
                }
            }
        }

        return ret;
    }
}
