package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by yansen on 16/9/22.
 */
@AdvancedFeignClient
public interface RemoteOrdersStatusChangeService {
    /**
     * 更新支付状态
     * @param orderId
     * @param consumerId
     * @param payStatus
     * @return
     */
    public DubboResult<Integer> updatePayOrderStatus(Long orderId, Long consumerId, String payStatus);

    /**
     * 扣积分成功，订单状态变更
     * @param orderId
     * @param consumerId
     * @return
     */
    public DubboResult<Integer> doMakeConsumeSuccess(Long orderId, Long consumerId);

    /**
     * 扣积分失败，订单状态变更
     * @param orderId
     * @param consumerId
     * @param failType
     * @param error4consumer
     * @param error4developer
     * @param error4admin
     * @return
     */
    public DubboResult<Integer> doMakeConsumeFail( Long orderId, Long consumerId, Integer failType,String error4consumer,String error4developer, String error4admin);

    /**加钱购支付成功 后 更新加钱购支付状态  为  pay_success
     * @param orderId
     * @param consumerId
     * @return
     */
    public DubboResult<Integer> doAmbConsumerPayStatusPaySuccess(Long orderId, Long consumerId);

    /**
     *
     * @param orderId
     * @param consumerId
     * @return
     */
    public DubboResult<Integer> doAuditPass(Long orderId, Long consumerId);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param error4consumer
     * @param error4developer
     * @param error4admin
     * @param failType
     * @return
     */
    public DubboResult<Integer> doAuditReject(Long orderId, Long consumerId, String error4consumer, String error4developer, String error4admin, Integer failType);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param payStatus
     * @param duibaPayStatus
     * @param consumerPayStatus
     * @return
     */
    public DubboResult<Integer> doMakeSuccess(Long orderId, Long consumerId, String payStatus, String duibaPayStatus, String consumerPayStatus);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param payStatus
     * @param duibaPayStatus
     * @param consumerPayStatus
     * @param consumerPaybackPrice
     * @return
     */
    DubboResult<Integer> doMakeFail(Long orderId, Long consumerId, String payStatus, String duibaPayStatus, String consumerPayStatus, Long consumerPaybackPrice);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param duibaPayStatus
     * @return
     */
    public DubboResult<Integer> updateDuibaPayOrderStatus(Long orderId, Long consumerId, String duibaPayStatus);

    /**
     * @param orderId
     * @param consumerId
     * @param supplierOrderId
     * @param bizParams
     * @param brief
     * @return
     */
    public DubboResult<Integer> doUpdateAllowInputUsed(Long orderId, Long consumerId, Long supplierOrderId, String bizParams, String brief);

    public Integer updateStatusInt(Long orderId, Long consumerId, Integer statusInt);

    /**
     * 更新为异常前会判断下状态，如果已经是取消或失效则不更新
     * @param orderId
     * @param consumerId
     * @return
     */
    public Integer updateStatusInt2Error(Long orderId, Long consumerId);

    Integer updatePaybackStatus(Long orderId, Long consumerId, String payStatus);
}
