package cn.com.duiba.order.center.api.paramquery;

import cn.com.duiba.order.center.api.paramquery.common.PageParam;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDateTime;

/**
 * 订单售后问题查询条件
 *
 * @author ykb
 * @date 2023-02-15
 */
@Getter
@Setter
@NoArgsConstructor
public class OrderAfterSaleSearchParam extends PageParam {

    /**
     * 时间创建
     */
    private LocalDateTime gmtCreate;

    /**
     * 时间修改
     */
    private LocalDateTime gmtModified;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 兑吧订单号
     */
    private String orderNum;

    /**
     * 用户uid
     */
    private String uId;

    /**
     * 类型@see
     */
    private Integer type;

    @Builder
    public OrderAfterSaleSearchParam(Integer pageNum, Integer pageSize, String orderBy, String desc, LocalDateTime gmtCreate, LocalDateTime gmtModified, Long appId, String orderNum, String uId, Integer type) {
        super(pageNum, pageSize, orderBy, desc);
        this.gmtCreate = gmtCreate;
        this.gmtModified = gmtModified;
        this.appId = appId;
        this.orderNum = orderNum;
        this.uId = uId;
        this.type = type;
    }
}
