package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.OrderAfterSaleDto;
import cn.com.duiba.order.center.api.dto.common.PageDto;
import cn.com.duiba.order.center.api.paramquery.OrderAfterSaleSearchParam;
import cn.com.duiba.order.center.api.paramquery.OrderAfterSaleCreateParam;

import java.util.List;

/**
 * 订单售后问题remote
 *
 * @author ykb
 * @date 2023-02-16
 */
@AdvancedFeignClient
public interface RemoteOrderAfterSaleService {

    /**
     * 创建
     *
     * @param entity 订单售后问题创建参数
     * @return int
     */
    int create(OrderAfterSaleCreateParam entity);

    /**
     * 分页查询
     *
     * @param query 入参
     * @return {@link PageDto}<{@link OrderAfterSaleDto}>
     */
    PageDto<OrderAfterSaleDto> findPage(OrderAfterSaleSearchParam query);

    /**
     * 查询列表
     *
     * @param query 入参
     * @return {@link List}<{@link OrderAfterSaleEntity}>
     */
    List<OrderAfterSaleDto> list(OrderAfterSaleSearchParam query);

}
